/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.fs;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.SharePointOnlineConnection;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.FSTestProvider;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SharePointOnlineFSTestProvider
implements FSTestProvider {
    private final SharePointOnlineConnection connection;
    private final BuiltinFSDatasets.SharePointOnlineDatasetConfig config;
    private final AuthCtx authCtx;
    private final SharePointOnlineConnection.SharePointOnlineClient client;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.fstestproviders.sharepointonline");

    public SharePointOnlineFSTestProvider(AuthCtx authCtx, DSSConnection connection, AbstractFSDatasetHandler.AbstractFSConfig config) {
        this.authCtx = authCtx;
        this.config = (BuiltinFSDatasets.SharePointOnlineDatasetConfig)config;
        this.connection = (SharePointOnlineConnection)connection;
        ProxySettings proxySettings = connection.getProxySettings();
        this.client = ((SharePointOnlineConnection)connection).getSharePointOnlineClient(authCtx, proxySettings);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, String> test(boolean listBuckets) {
        HashMap<String, String> connectionMetadata = new HashMap<String, String>();
        if (!listBuckets) {
            return connectionMetadata;
        }
        logger.info((Object)"Listing sites");
        if (StringUtils.isEmpty((CharSequence)this.config.siteSearch)) {
            if (this.config.siteId == null && this.config.site == null) {
                return connectionMetadata;
            }
            if (this.config.siteId != null) {
                SharePointOnlineConnection.SharePointOnlineClient.CustomSite site = this.client.getSiteById(this.config.siteId);
                connectionMetadata.put("sites", JSON.json(Collections.singletonList(site)));
            }
        } else {
            try {
                List<SharePointOnlineConnection.SharePointOnlineClient.CustomSite> searchSites = this.client.getSites(this.config.siteSearch);
                connectionMetadata.put("sites", JSON.json(searchSites));
            }
            catch (Exception e) {
                connectionMetadata.put("sharePointError", ExceptionUtils.getMessageWithCauses((Throwable)e));
                logger.error((Object)"Couldn't list sites", (Throwable)e);
            }
        }
        if (this.config.siteId != null) {
            try {
                List<SharePointOnlineConnection.SharePointOnlineClient.CustomDrive> drives = this.client.getDrives(this.config.siteId);
                connectionMetadata.put("drives", JSON.json(drives));
            }
            catch (Exception e) {
                connectionMetadata.put("sharePointError", ExceptionUtils.getMessageWithCauses((Throwable)e));
                logger.error((Object)"couldn't list drives", (Throwable)e);
            }
        }
        return connectionMetadata;
    }
}

