/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.mongodb;

import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.MongoDBConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.google.common.annotations.VisibleForTesting;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoDatabase;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;
import org.bson.conversions.Bson;

public class MongoDBConnectionWrapper
implements Closeable {
    public MongoDBConnection connection;
    public MongoClient client;
    public MongoDatabase db;

    public static MongoDBConnectionWrapper get(AuthCtx authCtx, String connectionName) throws IOException, DKUSecurityException {
        ConnectionsDAO connectionsDAO = (ConnectionsDAO)SpringUtils.getBean(ConnectionsDAO.class);
        MongoDBConnection conn = connectionsDAO.getMandatoryConnectionAs(authCtx, connectionName, MongoDBConnection.class);
        return new MongoDBConnectionWrapper(authCtx, conn);
    }

    @VisibleForTesting
    static ConnectionString buildConnectionString(String uri, ICredentialsService.BasicCredential credential) {
        ConnectionString connectionString;
        if (credential != null && (StringUtils.isNotBlank((String)credential.user) || StringUtils.isNotBlank((String)credential.password))) {
            try {
                if (new URI(uri).getUserInfo() != null) {
                    throw ErrorContext.iaef((String)"If you are providing a username and password separately, make sure to remove them from the connection URI: %s", (Object)uri, (Object[])new Object[0]);
                }
                StringBuilder uriStringBuilder = new StringBuilder(uri);
                String user = credential.user == null ? "" : URLEncoder.encode(credential.user, StandardCharsets.UTF_8);
                String password = credential.password == null ? "" : URLEncoder.encode(credential.password, StandardCharsets.UTF_8);
                uriStringBuilder.insert(uri.indexOf("//") + 2, user + ":" + password + "@");
                connectionString = new ConnectionString(uriStringBuilder.toString());
            }
            catch (URISyntaxException e) {
                throw ErrorContext.iaef((String)"Invalid URI: %s", (Object)uri, (Object[])new Object[0]);
            }
        } else {
            connectionString = new ConnectionString(uri);
        }
        return connectionString;
    }

    private void checkNotBlank(String str, String err, String arg) {
        if (StringUtils.isBlank((String)str)) {
            throw ErrorContext.iaef((String)err, (Object)arg, (Object[])new Object[0]);
        }
    }

    public MongoDBConnectionWrapper(AuthCtx authCtx, MongoDBConnection conn) throws IOException, DKUSecurityException {
        String dbName;
        this.connection = conn;
        ICredentialsService.BasicCredential cred = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null), ICredentialsService.BasicCredential.class);
        if (conn.params.useURI) {
            String uri = conn.params.uri;
            this.checkNotBlank(uri, "missing connection URI for MongoDB connection %s", conn.name);
            ConnectionString connectionString = MongoDBConnectionWrapper.buildConnectionString(uri, cred);
            dbName = connectionString.getDatabase() != null ? connectionString.getDatabase() : "";
            this.checkNotBlank(dbName, "missing database in MongoDB connection URI for connection %s", conn.name);
            this.client = MongoClients.create((ConnectionString)connectionString);
        } else {
            String host = conn.params.host;
            dbName = conn.params.db;
            this.checkNotBlank(host, "missing host for MongoDB connection %s", conn.name);
            this.checkNotBlank(dbName, "missing database for MongoDB connection %s", conn.name);
            ServerAddress addr = conn.params.port > 0 ? new ServerAddress(host, conn.params.port) : new ServerAddress(host);
            MongoClientSettings.Builder mongoClientSettingsBuilder = MongoClientSettings.builder();
            if (cred != null && StringUtils.isNotBlank((String)cred.user)) {
                char[] pwd = cred.password != null ? cred.password.toCharArray() : new char[]{};
                mongoClientSettingsBuilder.credential(MongoCredential.createCredential((String)cred.user, (String)dbName, (char[])pwd));
                ConnectionString connectionString = new ConnectionString("mongodb://" + String.valueOf(addr));
                mongoClientSettingsBuilder.applyConnectionString(connectionString);
            }
            MongoClientSettings mongoClientSettings = mongoClientSettingsBuilder.build();
            this.client = MongoClients.create((MongoClientSettings)mongoClientSettings);
        }
        try {
            this.db = this.client.getDatabase(dbName);
        }
        catch (Throwable t) {
            this.client.close();
            throw t;
        }
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public void test() {
        this.db.runCommand((Bson)new BsonDocument("ping", (BsonValue)new BsonInt32(1)));
    }
}

