/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets.streamwrite;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.sql.AbstractSQLTableDatasetHandler;
import com.dataiku.dip.datasets.streamwrite.CurrentTimestampTargetPartitionComputer;
import com.dataiku.dip.datasets.streamwrite.SQLBasedStreamWriter;
import com.dataiku.dip.datasets.streamwrite.TargetPartitionComputer;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUDateUtils;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MultiPartitionsSQLBasedStreamWriter
extends SQLBasedStreamWriter {
    private Map<String, SQLBasedStreamWriter.SQLBasedOpenOutputPartition> openPartitions = new HashMap<String, SQLBasedStreamWriter.SQLBasedOpenOutputPartition>();
    private final TargetPartitionComputer targetPartitionComputer;
    private final CurrentTimestampTargetPartitionComputer.ComputationTimezone computationTimezone = CurrentTimestampTargetPartitionComputer.ComputationTimezone.LOCAL;
    private static Logger logger = Logger.getLogger((String)"dip.stream.multipartition.sql.writer");

    public MultiPartitionsSQLBasedStreamWriter(AuthCtx authCtx, AbstractSQLTableDatasetHandler outputDH, String sourceId, int splitId) throws Exception {
        super(authCtx, outputDH, sourceId, splitId);
        this.targetPartitionComputer = new CurrentTimestampTargetPartitionComputer(outputDH.getDataset().getPartitioningSchema(), this.computationTimezone);
    }

    private SQLBasedStreamWriter.SQLBasedOpenOutputPartition getOrOpenPartition(String partitionId) throws Exception {
        SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop = this.openPartitions.get(partitionId);
        if (oop != null) {
            return oop;
        }
        oop = new SQLBasedStreamWriter.SQLBasedOpenOutputPartition(this);
        oop.setupNewOpenOutputPartition(partitionId);
        this.openPartitions.put(partitionId, oop);
        return oop;
    }

    @VisibleForTesting
    public void append(Row row, final String ts) throws Exception {
        CurrentTimestampTargetPartitionComputer.nowProvider = new CurrentTimestampTargetPartitionComputer.NowProvider(){

            @Override
            public long now() {
                return DKUDateUtils.parseISOLocal((String)ts);
            }
        };
        this.append(row);
    }

    @Override
    public void append(Row row) throws Exception {
        String partitionId = this.targetPartitionComputer.compute(row);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Will write row to " + partitionId));
        }
        SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop = this.getOrOpenPartition(partitionId);
        oop.writer.emitRow(row);
    }

    @Override
    protected void closeOpenPartitions() throws Exception {
        for (SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop : this.openPartitions.values()) {
            oop.lastRowEmitted();
        }
        this.openPartitions.clear();
    }

    @Override
    protected void cancelOpenPartitions() throws Exception {
        for (SQLBasedStreamWriter.SQLBasedOpenOutputPartition oop : this.openPartitions.values()) {
            oop.cancel();
        }
        this.openPartitions.clear();
    }
}

