/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.db;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.db.AbstractConnectionFactory;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.db.DSSDBConnectionsManagementService;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.SecretKeyGenerator;

public class ExternalDatabaseConnectionFactory
extends AbstractConnectionFactory {
    public static final String DEBUG_ID_START = "dssdb-ext-";
    private final SQLConnectionProvider.SQLConnectionData sqlConnectionData;

    ExternalDatabaseConnectionFactory(SQLConnectionProvider.SQLConnectionData sqlConnectionData) {
        this.sqlConnectionData = sqlConnectionData;
    }

    @Override
    protected String getFactoryType() {
        return "single";
    }

    @Override
    protected String[] metricNamesForValidation() {
        return new String[]{DSSDBConnectionsManagementService.buildSingleDBMetricName("validateConnection")};
    }

    @Override
    protected String[] metricNamesForValidationFailure() {
        return new String[]{DSSDBConnectionsManagementService.buildSingleDBMetricName("droppedConnections")};
    }

    @Override
    protected SQLDialect getDialect() {
        return this.sqlConnectionData.getDialect();
    }

    public DSSDBConnection makeObject() throws Exception {
        try (DSSMetrics.MTimeCtx tctx = DSSMetrics.mtimeCtx((String[])new String[]{DSSDBConnectionsManagementService.buildSingleDBMetricName("createConnection")});){
            logger.info((Object)"Creating a new connection to external DSS DB");
            String debugId = DEBUG_ID_START + SecretKeyGenerator.generateSmall();
            SQLConnectionProvider.SQLConnectionWrapper sqlConnectionWrapper = SQLConnectionProvider.newConnection(this.sqlConnectionData, DSSAuthCtx.newNone(), null, debugId, false, true);
            sqlConnectionWrapper.setAutoCommit(false);
            DSSDBConnection dSSDBConnection = new DSSDBConnection(sqlConnectionWrapper, this.connectionPool, debugId);
            return dSSDBConnection;
        }
    }
}

