/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docextraction.common;

import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.j2py.annotations.PyModel;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.web.multipart.MultipartFile;

public class InputRefs {

    public static class SingleInlineImage {
        public String content;
        @Nullable
        public String mimeType;

        public SingleInlineImage(String content, @Nullable String mimeType) {
            this.content = content;
            this.mimeType = mimeType;
        }
    }

    @PyModel
    public static class ManagedFolderImagesRef
    extends ImagesRef {
        public String managedFolderId;
        public String commonPrefixPath;
        public List<String> imagesPaths = new ArrayList<String>();

        @Override
        public Integer getImageCount() {
            return this.imagesPaths.size();
        }
    }

    @PyModel
    public static class InlineImagesRef
    extends ImagesRef {
        public List<SingleInlineImage> inlineImages = new ArrayList<SingleInlineImage>();

        @Override
        public Integer getImageCount() {
            return this.inlineImages.size();
        }
    }

    @PolyJSON(value={@Mapping(type="inline", value=InlineImagesRef.class), @Mapping(type="managed_folder", value=ManagedFolderImagesRef.class)})
    @PyModel
    public static abstract class ImagesRef {
        public abstract Integer getImageCount();
    }

    @PyModel
    public static class LocalFileDocumentRef
    extends DocumentRef {
        public MultipartFile multipartFile;
    }

    @PyModel
    public static class TmpDocumentRef
    extends DocumentRef {
        public String tmpFileName;
        public String originalFileName;
    }

    @PyModel
    public static class ManagedFolderDocumentRefWithMetadata {
        public ManagedFolderDocumentRef documentRef;
        public String securityToken;
        public final String securityTokenHash;
        public HashMap<String, String> userMetadata;
        public final String userMetadataHash;

        public ManagedFolderDocumentRefWithMetadata(ManagedFolderDocumentRef documentRef, String securityToken, HashMap<String, String> userMetadata) {
            this.documentRef = documentRef;
            this.securityToken = securityToken;
            this.userMetadata = userMetadata;
            this.securityTokenHash = ManagedFolderDocumentRefWithMetadata.computeSecurityTokenHash(this.securityToken);
            this.userMetadataHash = ManagedFolderDocumentRefWithMetadata.computeMetadataHash(this.userMetadata);
        }

        public ManagedFolderDocumentRefWithMetadata(ManagedFolderDocumentRef documentRef, String securityTokenHash, String userMetadataHash) {
            this.documentRef = documentRef;
            this.securityToken = null;
            this.userMetadata = null;
            this.securityTokenHash = securityTokenHash;
            this.userMetadataHash = userMetadataHash;
        }

        private static String computeSecurityTokenHash(String securityToken) {
            if (securityToken == null || securityToken.isEmpty()) {
                return null;
            }
            TypeToken<Set<String>> typeToken = new TypeToken<Set<String>>(){};
            Set tokensSet = (Set)JSON.parse((String)securityToken, (TypeToken)typeToken);
            if (tokensSet.isEmpty()) {
                return null;
            }
            return String.valueOf(tokensSet.hashCode());
        }

        private static String computeMetadataHash(HashMap<String, String> userMetadata) {
            if (userMetadata == null || userMetadata.isEmpty()) {
                return null;
            }
            return String.valueOf(userMetadata.hashCode());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagedFolderDocumentRefWithMetadata other = (ManagedFolderDocumentRefWithMetadata)o;
            return Objects.equals(this.documentRef, other.documentRef) && Objects.equals(this.securityTokenHash, other.securityTokenHash) && Objects.equals(this.userMetadataHash, other.userMetadataHash);
        }

        public int hashCode() {
            return Objects.hash(this.documentRef, this.securityTokenHash, this.userMetadataHash);
        }
    }

    @PyModel
    public static class ManagedFolderDocumentRef
    extends DocumentRef {
        public String filePath;
        public String managedFolderId;
        public long fileSize;
        public long fileLastModified;

        public ManagedFolderDocumentRef() {
        }

        public ManagedFolderDocumentRef(String managedFolderId, FSPath document) {
            this.managedFolderId = managedFolderId;
            this.filePath = document.path();
            this.fileSize = document.getSize();
            this.fileLastModified = document.getLastModified();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManagedFolderDocumentRef other = (ManagedFolderDocumentRef)o;
            return Objects.equals(this.filePath, other.filePath) && Objects.equals(this.fileSize, other.fileSize) && Objects.equals(this.fileLastModified, other.fileLastModified);
        }

        public int hashCode() {
            return Objects.hash(this.filePath, this.fileSize, this.fileLastModified);
        }
    }

    @PolyJSON(value={@Mapping(type="managed_folder", value=ManagedFolderDocumentRef.class), @Mapping(type="tmp_file", value=TmpDocumentRef.class), @Mapping(type="local_file", value=LocalFileDocumentRef.class)})
    @PyModel
    public static abstract class DocumentRef {
    }
}

