/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.docgen.resolver;

import com.dataiku.dip.docgen.resolver.GenericPlaceholder;
import com.dataiku.dip.docgen.resolver.IterableDescription;
import com.dataiku.dip.docgen.resolver.PlaceholderExpectedException;
import com.dataiku.dip.docgen.resolver.PlaceholderOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IterableUtils;

public class PlaceholderStore<DocGenContext> {
    private final Map<String, GenericPlaceholder.IterablePlaceholder<? super DocGenContext, ?, ?>> iterableStore = new HashMap();
    private final Map<String, GenericPlaceholder.SimplePlaceholder<? super DocGenContext, ?, ? extends PlaceholderOutput>> simpleStore = new HashMap();
    public final Map<Class<?>, Function<Object, String>> errorContextDescriptionMap = new HashMap();
    private final Map<String, Class<?>> replacementsTypes = new HashMap();

    GenericPlaceholder.IterablePlaceholder<? super DocGenContext, ?, ?> getIterablePlaceholder(String name) {
        return this.iterableStore.get(name);
    }

    GenericPlaceholder.SimplePlaceholder<? super DocGenContext, ?, ? extends PlaceholderOutput> getSimplePlaceholder(String name) {
        return this.simpleStore.get(name);
    }

    public <I> void register(String name, final GenericPlaceholder.IterablePlaceholder<? super DocGenContext, I, ?> placeholder) {
        final IterableDescription<I, ?> typeInfos = placeholder.getDescription();
        this.checkValidName(name, typeInfos.input != Void.class);
        this.checkInputTypeCompatibility(name, typeInfos.input);
        this.checkOutputTypeCompatibility(name, typeInfos.output, typeInfos.replacement);
        this.iterableStore.put(name, placeholder);
        this.register(name + ".count", new GenericPlaceholder.TextPlaceholder<DocGenContext, I>(){

            @Override
            public PlaceholderOutput.Text resolve(DocGenContext docGenContext, I resolvedVariable) throws PlaceholderExpectedException {
                return new PlaceholderOutput.Text(String.valueOf(IterableUtils.size((Iterable)((Iterable)placeholder.resolve(docGenContext, resolvedVariable)))));
            }

            @Override
            public Class<I> getInputType() {
                return typeInfos.input;
            }
        });
    }

    public void register(String name, GenericPlaceholder.SimplePlaceholder<? super DocGenContext, ?, ?> placeholder) {
        Class<?> input = placeholder.getInputType();
        this.checkValidName(name, input != Void.class);
        this.checkInputTypeCompatibility(name, input);
        this.simpleStore.put(name, placeholder);
    }

    private void checkValidName(String name, boolean hasInput) {
        assert (hasInput == name.startsWith("$")) : "Placeholders name must start with $ if and only if they have a non-void input type. This is required to avoid name conflicts between what can be directly used by the user and what has to be resolved as a variable.";
        assert (!this.simpleStore.containsKey(name) && !this.iterableStore.containsKey(name)) : "Tried to register two placeholders with the same name : " + name;
    }

    private void checkInputTypeCompatibility(String name, Class<?> inputClass) {
        String prefix = name.split(Pattern.quote("."))[0];
        if (inputClass != Void.class) {
            assert (this.replacementsTypes.containsKey(prefix)) : "Tried to register a placeholder with an input that is unknown (prefix=" + prefix + "). Maybe check the order of declaration";
            assert (inputClass.isAssignableFrom(this.replacementsTypes.get(prefix))) : "Tried to register a placeholder with an input that is incompatible with declared output for replacement '" + prefix + "': got " + inputClass.getCanonicalName() + " expected " + this.replacementsTypes.get(prefix).getCanonicalName();
        }
    }

    private void checkOutputTypeCompatibility(String name, Class<?> outputClass, String replacement) {
        assert (replacement.startsWith("$")) : "All iterable placeholders replacements must start with a $";
        if (!this.replacementsTypes.containsKey(replacement)) {
            this.replacementsTypes.put(replacement, outputClass);
        } else assert (this.replacementsTypes.get(replacement).isAssignableFrom(outputClass)) : "Tried to register two incompatible iterables placeholders with the same replacement '" + replacement + "': got " + outputClass.getCanonicalName() + " expected " + this.replacementsTypes.get(replacement).getCanonicalName() + ". second iterable was " + name;
    }

    public <T> void registerErrorContextDescription(Class<T> clazz, Function<T, String> method) {
        this.errorContextDescriptionMap.put(clazz, method);
    }

    public Optional<String> resolveErrorContextDescription(Object toDescribe) {
        Class<?> currentClass;
        for (currentClass = toDescribe.getClass(); !this.errorContextDescriptionMap.containsKey(currentClass) && currentClass != Object.class; currentClass = currentClass.getSuperclass()) {
        }
        return Optional.ofNullable(this.errorContextDescriptionMap.get(currentClass)).map(descriptionMethod -> (String)descriptionMethod.apply(toDescribe));
    }
}

