/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.compute;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.eda.compute.caching.CachedRunner;
import com.dataiku.dip.eda.compute.caching.ComputeResultCachingService;
import com.dataiku.dip.eda.compute.caching.KernelCachingService;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.transformers.Factorizer;
import com.dataiku.dip.eda.compute.computations.transformers.Flattener;
import com.dataiku.dip.eda.compute.computations.transformers.TransformingRunner;
import com.dataiku.dip.eda.compute.engine.ComputationRunner;
import com.dataiku.dip.eda.compute.engine.NoopRunner;
import com.dataiku.dip.eda.compute.engine.SmoothlyClosableComputationRunner;
import com.dataiku.dip.eda.compute.engine.python.EDAKernelProtocol;
import com.dataiku.dip.eda.compute.sampling.Sample;
import com.dataiku.dip.eda.compute.sampling.SampleRequest;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.KubernetesSimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernel;
import com.dataiku.dip.io.SimplePythonKernelFactory;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.cache.Cache;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComputeService {
    @Autowired
    ComputeResultCachingService resultCache;
    @Autowired
    KernelCachingService kernelCache;
    private ScheduledExecutorService maintenanceThread = Executors.newSingleThreadScheduledExecutor();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.eda.compute");

    public ComputationRunner getCacheReader(Sample sample) {
        logger.infoV("Getting cache runner for sample %s", new Object[]{sample.id});
        return new CachedRunner((Cache<Computation, ComputationResult>)this.resultCache.get(sample.id), new NoopRunner());
    }

    public ComputationRunner getCachedSampleRunner(AuthCtx authCtx, Sample sample) {
        SmoothlyClosableComputationRunner runner = this.kernelCache.get(sample.getId(), () -> this.createSampleKernel(authCtx, sample));
        runner.incRefCount();
        return new CachedRunner((Cache<Computation, ComputationResult>)this.resultCache.get(sample.getId()), runner);
    }

    public ComputationRunner getDatasetRunner(AuthCtx authCtx, SampleRequest sampleRequest) throws Exception {
        logger.infoV("Creating python kernel runner for dataset %s", new Object[]{sampleRequest.dataset.getFullName()});
        SimplePythonKernel simplePythonKernel = this.prepareKernel(authCtx, sampleRequest.projectKey, sampleRequest.containerConfName);
        EDAKernelProtocol protocol = new EDAKernelProtocol(simplePythonKernel);
        try {
            simplePythonKernel.start();
            protocol.loadDataset(sampleRequest.dataset, sampleRequest.dataSpec.datasetSelection);
            this.logCRUForSimplePythonKernel(simplePythonKernel);
        }
        catch (Exception e) {
            protocol.close();
            throw e;
        }
        return new TransformingRunner(new Flattener(), new TransformingRunner(new Factorizer(), protocol));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComputationRunner createSampleKernel(AuthCtx authCtx, Sample sample) throws Exception {
        ComputeResourceUsageContext ctx = ComputeResourceUsageContext.forEDA((AuthCtx)authCtx, (String)sample.getProjectKey(), (String)sample.dataSpec.inputDatasetSmartName);
        CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ctx);
        try {
            AnyLoc datasetLoc = sample.getDatasetLoc();
            if (logger.isDebugEnabled()) {
                logger.debugV("Creating python kernel runner for sample %s", new Object[]{sample.id});
            }
            SimplePythonKernel simplePythonKernel = this.prepareKernel(authCtx, datasetLoc.getProjectKey(), sample.containerConfName);
            EDAKernelProtocol protocol = new EDAKernelProtocol(simplePythonKernel);
            try {
                simplePythonKernel.start();
                protocol.loadSample(sample);
                this.logCRUForSimplePythonKernel(simplePythonKernel);
            }
            catch (Exception e) {
                protocol.close();
                File sampleMetaFile = Sample.metaFile(sample.id);
                if (null == sampleMetaFile || !sampleMetaFile.exists() || !sampleMetaFile.isFile()) {
                    throw new DeletedSampleException("Sample " + sample.id + " seems to have been deleted", e);
                }
                throw e;
            }
            TransformingRunner transformingRunner = new TransformingRunner(new Factorizer(), protocol);
            return transformingRunner;
        }
        finally {
            CurrentComputeResourceUsageContext.clear();
        }
    }

    private void logCRUForSimplePythonKernel(SimplePythonKernel simplePythonKernel) {
        try {
            if (simplePythonKernel instanceof KubernetesSimplePythonKernel) {
                KubernetesSimplePythonKernel k8sSimplePythonKernel = (KubernetesSimplePythonKernel)simplePythonKernel;
                ComputeResourceUsage cru = k8sSimplePythonKernel.buildComputeResourceUsage();
                cru.reportCompleteNoFail();
            }
        }
        catch (IOException e) {
            logger.error((Object)"An error occurred during construction or logging of the CRU", (Throwable)e);
        }
    }

    private SimplePythonKernel prepareKernel(AuthCtx authCtx, String projectKey, String containerConfName) throws IOException, DKUSecurityException, CodedException {
        return SimplePythonKernelFactory.prepareKernel((DSSAuthCtx)authCtx, projectKey, GeneralSettingsDAO.CGrouppableProcessType.EDA, null, "dataiku.eda.server", false, containerConfName, "eda");
    }

    public void clearCaches() {
        logger.info((Object)"Clearing computation results and kernel caches");
        this.resultCache.invalidateAll();
        this.kernelCache.invalidateAll();
    }

    @PostConstruct
    public void postConstruct() {
        int CLEANUP_PERIOD_MN = 5;
        logger.infoV("Scheduling periodic cleanup of kernel and result cache every %d minutes, starting in %d minutes", new Object[]{5, 5});
        this.maintenanceThread.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                ComputeService.this.kernelCache.cleanUp();
                ComputeService.this.resultCache.cleanUp();
            }
        }, 5L, 5L, TimeUnit.MINUTES);
    }

    @PreDestroy
    public void preDestroy() {
        this.maintenanceThread.shutdownNow();
    }

    public static class DeletedSampleException
    extends RuntimeException {
        public DeletedSampleException(String msg, Throwable t) {
            super(msg, t);
        }
    }
}

