/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.FailedResult;
import com.dataiku.dip.eda.compute.computations.UnavailableResult;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.utils.NotImplementedException;
import com.google.common.reflect.TypeToken;

public abstract class AbstractCompiledCard<CompParams extends Computation, CompResult extends AvailableResult>
implements CompiledCard {
    private Class<CompResult> getExpectedResultClass() {
        return new TypeToken<CompResult>(this.getClass()){}.getRawType();
    }

    public abstract CompParams getComputationPlan();

    @Override
    public CardResult buildResult(ComputationResult result, ComputationResultDataStreamer dataStreamer) {
        if (result.isAvailable()) {
            return this.buildFromAvailableResult((AvailableResult)((Object)result.as(this.getExpectedResultClass())), dataStreamer);
        }
        return AbstractCompiledCard.buildFromUnavailableResult(result.asUnavailable());
    }

    protected CardResult buildFromAvailableResult(CompResult result, ComputationResultDataStreamer dataStreamer) {
        if (((ComputationResult)((Object)result)).isFullyAvailable()) {
            return this.buildFromFullyAvailableResult(result, dataStreamer);
        }
        return AbstractCompiledCard.buildFromRecursivelyUnavailableResult(result);
    }

    protected CardResult buildFromFullyAvailableResult(CompResult result, ComputationResultDataStreamer dataStreamer) {
        return this.buildFromFullyAvailableResult(result);
    }

    protected CardResult buildFromFullyAvailableResult(CompResult result) {
        throw new NotImplementedException();
    }

    public static CardResult.UnavailableCardResult buildFromRecursivelyUnavailableResult(ComputationResult result) {
        if (result.isFullyAvailable()) {
            throw new IllegalStateException("The computation result must not be fully available.");
        }
        if (result.isAtLeastPartiallyFailed()) {
            FailedResult failedResult = result.getFirstFailedResult();
            return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.FAILURE, failedResult.message, failedResult.code);
        }
        return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.NOT_COMPUTED, "Partially not computed", null);
    }

    public static CardResult.UnavailableCardResult buildFromUnavailableResult(UnavailableResult result) {
        if (result.isFailed()) {
            FailedResult failedResult = result.asFailed();
            return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.FAILURE, failedResult.message, failedResult.code);
        }
        return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.NOT_COMPUTED, null, null);
    }
}

