/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.common;

import com.dataiku.dip.eda.compute.computations.AvailableResult;
import com.dataiku.dip.eda.compute.computations.Computation;
import com.dataiku.dip.eda.compute.computations.ComputationResult;
import com.dataiku.dip.eda.compute.computations.FailedResult;
import com.dataiku.dip.eda.compute.computations.common.GroupedComputation;
import com.dataiku.dip.eda.compute.engine.ComputationResultDataStreamer;
import com.dataiku.dip.eda.compute.filtering.Filter;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.dataiku.dip.eda.worksheets.models.SplitBySpec;
import com.dataiku.dip.utils.DKULogger;
import java.util.ArrayList;
import java.util.List;

public class GroupedCompiledCardWrapper
extends AbstractCompiledCard<Computation, AvailableResult> {
    private final SplitBySpec splitBy;
    private final CompiledCard card;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.eda.worksheets.grouping");

    public GroupedCompiledCardWrapper(SplitBySpec splitBySpec, CompiledCard card) {
        this.splitBy = splitBySpec;
        this.card = card;
    }

    @Override
    public Computation getComputationPlan() {
        return new GroupedComputation(this.card.getComputationPlan(), this.splitBy.asGrouping());
    }

    @Override
    public CardResult buildResult(ComputationResult result, ComputationResultDataStreamer dataStreamer) {
        if (result.isFailed()) {
            FailedResult failedResult = result.asFailed();
            return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.FAILURE, failedResult.message, failedResult.code);
        }
        if (result.isNotComputed()) {
            return new CardResult.UnavailableCardResult(CardResult.UnavailabilityReason.NOT_COMPUTED, "Not computed", null);
        }
        ArrayList<CardResult> cardResults = new ArrayList<CardResult>();
        for (GroupedComputation.GroupResult groupResult : result.asGrouped()) {
            CardResult cardResult = this.card.buildResult(groupResult.result, dataStreamer);
            ComputationResult.ComputationCounts counts = groupResult.result.getComputationCounts();
            cardResult.computationCount = counts.computationsCount;
            cardResult.notComputedCount = counts.notComputedCount;
            cardResult.failedComputationsCount = counts.failedComputationsCount;
            cardResults.add(cardResult);
        }
        return new GroupedCardResult(result.asGrouped().groups.listFilters(), cardResults);
    }

    public static class GroupedCardResult
    extends CardResult {
        public static final String TYPE = "groups";
        public List<Filter> groups;
        public List<CardResult> results;

        public GroupedCardResult(List<Filter> groups, List<CardResult> results) {
            this.groups = groups;
            this.results = results;
        }

        private GroupedCardResult() {
        }
    }
}

