/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.cards.univariate_header;

import com.dataiku.dip.eda.compute.computations.univariate.Quantiles;
import com.dataiku.dip.eda.worksheets.cards.CardResult;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.AbstractCompiledCard;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceInterval;
import com.dataiku.dip.eda.worksheets.cards.common.CardWithConfidenceLevel;
import com.dataiku.dip.eda.worksheets.cards.common.CompiledCard;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;

public class QuantilesTableCard
extends UnivariateCard
implements CardWithConfidenceLevel,
CardWithConfidenceInterval {
    public static final String TYPE = "quantile_table";
    @Nullable
    public List<Double> customFreqs;
    public double confidenceLevel;
    public boolean showConfidenceInterval;

    @Override
    public void setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
    }

    @Override
    public void setShowConfidenceInterval(boolean showConfidenceInterval) {
        this.showConfidenceInterval = showConfidenceInterval;
    }

    @Override
    protected CompiledCard compileNoSplitNoFilter() {
        return new AbstractCompiledCard<Quantiles, Quantiles.QuantilesResult>(){

            @Override
            public Quantiles getComputationPlan() {
                Quantiles params = new Quantiles(QuantilesTableCard.this.column.name);
                params.freqs = QuantilesTableCard.this.customFreqs == null ? Lists.newArrayList((Object[])new Double[]{0.01, 0.05, 0.25, 0.5, 0.75, 0.95, 0.99}) : QuantilesTableCard.this.customFreqs;
                params.confidence = QuantilesTableCard.this.showConfidenceInterval ? Double.valueOf(QuantilesTableCard.this.confidenceLevel) : null;
                return params;
            }

            @Override
            public CardResult buildFromFullyAvailableResult(Quantiles.QuantilesResult result) {
                return new QuantilesTableCardResult(result.quantiles);
            }
        };
    }

    public static class QuantilesTableCardResult
    extends CardResult {
        public List<Quantiles.QuantileDesc> quantiles;

        public QuantilesTableCardResult(List<Quantiles.QuantileDesc> quantiles) {
            this.quantiles = quantiles;
        }

        private QuantilesTableCardResult() {
        }
    }
}

