/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.BivariateCard;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateBoxPlotCard;
import com.dataiku.dip.eda.worksheets.cards.bivariate_header.BivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.NumericalHistogramCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BivariateSuggestionCleaner {
    private final BivariatePairing boxPlot2dPairing = new BivariatePairing();
    private final BivariatePairing frequencyTable2dPairing = new BivariatePairing();

    public List<SuggestCards.SuggestedCard> cleanRedundantSuggestions(List<SuggestCards.SuggestedCard> suggestions) {
        this.computePairings(suggestions);
        return suggestions.stream().filter(it -> !this.isRedundant((SuggestCards.SuggestedCard)it)).collect(Collectors.toList());
    }

    private void computePairings(List<SuggestCards.SuggestedCard> suggestions) {
        this.boxPlot2dPairing.clear();
        this.frequencyTable2dPairing.clear();
        for (SuggestCards.SuggestedCard suggestion : suggestions) {
            BivariateCard card;
            if (suggestion.card instanceof BivariateBoxPlotCard) {
                card = (BivariateBoxPlotCard)suggestion.card;
                this.boxPlot2dPairing.addPairingFrom(card);
                continue;
            }
            if (!(suggestion.card instanceof BivariateFrequencyTableCard)) continue;
            card = (BivariateFrequencyTableCard)suggestion.card;
            this.frequencyTable2dPairing.addPairingFrom(card);
        }
    }

    private boolean isRedundant(SuggestCards.SuggestedCard suggestion) {
        if (suggestion.card instanceof NumericalHistogramCard) {
            NumericalHistogramCard card = (NumericalHistogramCard)suggestion.card;
            if (card.isBoxPlotOnly()) {
                return this.boxPlot2dPairing.containsSamePairingThan(card);
            }
            return false;
        }
        if (suggestion.card instanceof UnivariateFrequencyTableCard) {
            UnivariateFrequencyTableCard card = (UnivariateFrequencyTableCard)suggestion.card;
            return this.frequencyTable2dPairing.containsSamePairingThan(card);
        }
        return false;
    }

    private static class BivariatePairing {
        private final Map<String, Set<String>> state = new HashMap<String, Set<String>>();

        private BivariatePairing() {
        }

        void clear() {
            this.state.clear();
        }

        void addPairingFrom(BivariateCard card) {
            String yColumnName = card.yColumn.name;
            String xColumnName = card.xColumn.name;
            this.addPairing(yColumnName, xColumnName);
            this.addPairing(xColumnName, yColumnName);
        }

        private void addPairing(String response, String factor) {
            if (!this.state.containsKey(response)) {
                this.state.put(response, new HashSet());
            }
            this.state.get(response).add(factor);
        }

        boolean containsSamePairingThan(UnivariateCard card) {
            if (card.splitBy == null) {
                return false;
            }
            String candidateResponse = card.column.name;
            String candidateFactor = card.splitBy.groupingColumn.name;
            return this.state.containsKey(candidateResponse) && this.state.get(candidateResponse).contains(candidateFactor);
        }
    }
}

