/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.worksheets.cards.ParallelCoordinatesPlotCard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ParallelCoordinatesPlotSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() < 2) {
            return Collections.emptyList();
        }
        if (!sniffedVariables.stream().allMatch(SniffedVariable::holdsNumericalValues)) {
            return Collections.emptyList();
        }
        List<Variable> variables = sniffedVariables.stream().map(Suggester::toContinuousVariable).collect(Collectors.toList());
        return Collections.singletonList(this.suggestParallelCoordinatesPlot(variables));
    }

    private SuggestCards.SuggestedCard suggestParallelCoordinatesPlot(List<Variable> variables) {
        ParallelCoordinatesPlotCard card = new ParallelCoordinatesPlotCard(variables);
        card.maxNumberOfPoints = 1000;
        return new SuggestCards.SuggestedCard("Parallel coordinate plot", card);
    }
}

