/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.eda.worksheets.suggester;

import com.dataiku.dip.eda.compute.computations.timeseries.PACF;
import com.dataiku.dip.eda.compute.resampling.ResamplerSettings;
import com.dataiku.dip.eda.worksheets.cards.ACFPlotCard;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.DurbinWatsonCard;
import com.dataiku.dip.eda.worksheets.cards.MannKendallTestCard;
import com.dataiku.dip.eda.worksheets.cards.TimeSeriesCard;
import com.dataiku.dip.eda.worksheets.cards.UnitRootTestADFCard;
import com.dataiku.dip.eda.worksheets.cards.UnitRootTestKPSSCard;
import com.dataiku.dip.eda.worksheets.cards.UnitRootTestZACard;
import com.dataiku.dip.eda.worksheets.models.Variable;
import com.dataiku.dip.eda.worksheets.queries.SuggestCards;
import com.dataiku.dip.eda.worksheets.suggester.SniffedVariable;
import com.dataiku.dip.eda.worksheets.suggester.Suggester;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class TimeSeriesAnalysisSuggester
implements Suggester {
    @Override
    public List<SuggestCards.SuggestedCard> suggestCards(List<SniffedVariable> sniffedVariables) {
        if (sniffedVariables.size() < 2) {
            return Collections.emptyList();
        }
        List sniffedTemporalVariables = sniffedVariables.stream().filter(SniffedVariable::holdsTemporalValues).collect(Collectors.toList());
        if (sniffedTemporalVariables.size() != 1) {
            return Collections.emptyList();
        }
        SniffedVariable sniffedTemporalVariable = (SniffedVariable)sniffedTemporalVariables.get(0);
        List<SniffedVariable> sniffedSeriesIdentifierVariables = sniffedVariables.stream().filter(SniffedVariable::isLikelyCategorical).filter(sniffedTemporalVariable::hasSeriesIdentifier).collect(Collectors.toList());
        if (sniffedVariables.size() - sniffedSeriesIdentifierVariables.size() != 2) {
            return Collections.emptyList();
        }
        List sniffedSeriesVariables = sniffedVariables.stream().filter(it -> !it.equals(sniffedTemporalVariable)).filter(it -> !sniffedSeriesIdentifierVariables.contains(it)).filter(SniffedVariable::holdsNumericalValues).collect(Collectors.toList());
        if (sniffedSeriesVariables.size() != 1) {
            return Collections.emptyList();
        }
        return this.suggestCards((SniffedVariable)sniffedSeriesVariables.get(0), sniffedTemporalVariable, sniffedSeriesIdentifierVariables);
    }

    private List<SuggestCards.SuggestedCard> suggestCards(SniffedVariable sniffedSeriesVariable, SniffedVariable sniffedTimeVariable, List<SniffedVariable> sniffedSeriesIdVariables) {
        String seriesDefinition;
        Variable seriesVariable = Suggester.toContinuousVariable(sniffedSeriesVariable);
        Variable timeVariable = Suggester.toCategoricalVariable(sniffedTimeVariable);
        List seriesIdentifiers = sniffedSeriesIdVariables.stream().map(Suggester::toCategoricalVariable).map(TimeSeriesCard.TimeSeriesIdentifier::new).collect(Collectors.toList());
        ResamplerSettings resamplerSettings = this.buildResamplerSettings(sniffedTimeVariable);
        if (seriesIdentifiers.size() > 0) {
            String seriesIdDefinition = seriesIdentifiers.stream().map(it -> it.column.name).collect(Collectors.joining(", "));
            seriesDefinition = String.format("on %s through %s (using %s)", seriesVariable.name, timeVariable.name, seriesIdDefinition);
        } else {
            seriesDefinition = String.format("on %s through %s", seriesVariable.name, timeVariable.name);
        }
        HashMap<Object, TimeSeriesCard> cardsByName = new HashMap<Object, TimeSeriesCard>();
        ACFPlotCard acf = new ACFPlotCard(seriesVariable, timeVariable, true);
        acf.showSummary = true;
        cardsByName.put("Auto-correlation function " + seriesDefinition, acf);
        ACFPlotCard pacf = new ACFPlotCard(seriesVariable, timeVariable, PACF.Method.LEVINSON_DURBIN);
        pacf.showSummary = true;
        cardsByName.put("Partial auto-correlation function " + seriesDefinition, pacf);
        MannKendallTestCard mkTest = new MannKendallTestCard(seriesVariable, timeVariable);
        cardsByName.put("Mann-Kendall trend test " + seriesDefinition, mkTest);
        UnitRootTestADFCard adfTest = new UnitRootTestADFCard(seriesVariable, timeVariable);
        cardsByName.put("Augmented Dickey-Fuller test " + seriesDefinition, adfTest);
        UnitRootTestKPSSCard kpssTest = new UnitRootTestKPSSCard(seriesVariable, timeVariable);
        cardsByName.put("KPSS test " + seriesDefinition, kpssTest);
        UnitRootTestZACard zaTest = new UnitRootTestZACard(seriesVariable, timeVariable);
        cardsByName.put("Zivot-Andrews test " + seriesDefinition, zaTest);
        DurbinWatsonCard dw = new DurbinWatsonCard(seriesVariable, timeVariable);
        cardsByName.put("Durbin-Watson statistic " + seriesDefinition, dw);
        cardsByName.forEach((name, card) -> {
            card.seriesIdentifiers = seriesIdentifiers;
            card.resamplerSettings = resamplerSettings;
        });
        return cardsByName.entrySet().stream().map(it -> new SuggestCards.SuggestedCard((String)it.getKey(), (Card)((Object)((Object)it.getValue())))).collect(Collectors.toList());
    }

    private ResamplerSettings buildResamplerSettings(SniffedVariable timeVariable) {
        if (timeVariable.matchTimeStepResult.nSteps == 1) {
            return null;
        }
        ResamplerSettings settings = new ResamplerSettings(timeVariable.guessTimeStepResult.nTimeUnits, timeVariable.guessTimeStepResult.timeUnit);
        settings.extrapolationMethod = ResamplerSettings.ExtrapolationMethod.PREVIOUS_NEXT;
        settings.duplicateTimestampsHandlingMethod = ResamplerSettings.DuplicateTimestampsHandlingMethod.DROP_IF_CONFLICTING;
        return settings;
    }
}

