/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.engine;

import com.dataiku.dip.utils.DKULogger;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AsyncCloser {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("AsyncCloser-%d").build());
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.engine");

    public void close(AutoCloseable closeable, String resourceName) {
        logger.info((Object)String.format("Schedule closing for %s", resourceName));
        EXECUTOR.submit(() -> {
            try {
                closeable.close();
                logger.info((Object)String.format("Successfully closed %s", resourceName));
            }
            catch (Exception e) {
                logger.error((Object)String.format("Failed to close %s", resourceName), (Throwable)e);
            }
        });
    }

    public void close(AutoCloseable closeable) {
        this.close(closeable, closeable.getClass().getSimpleName());
    }
}

