/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.input;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.input.AbstractSampledExport;
import com.dataiku.dip.export.input.ExportInput;
import com.dataiku.dip.export.input.Sampler;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.queries.QueryParams;
import com.dataiku.dip.queries.SQLQueryRuntime;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class SQLQueryExporter
extends AbstractSampledExport {
    @Autowired
    private VariablesService variablesService;
    private ExportInput.InputDescription desc = new ExportInput.InputDescription();
    private SQLNotebookQuery query;
    private String projectKey;
    private final String notebookId;
    private SQLQueryRuntime queryRuntime;
    private SQLQueryRuntime.SQLQueryIterator it;
    private Schema schema;
    private String sql;
    private AuthCtx authCtx;
    private static Logger logger = Logger.getLogger((String)"dip.sql.exporter");

    public SQLQueryExporter(SQLNotebookQuery query, String projectKey, String notebookId, AuthCtx authCtx) {
        this.projectKey = projectKey;
        this.notebookId = notebookId;
        this.authCtx = authCtx;
        SpringUtils.getInstance().autowire((Object)this);
        VariablesContext vc = this.variablesService.getContext(projectKey);
        this.query = query;
        this.desc.description = this.sql = query.getExpandedSql(vc);
        this.desc.name = "SQL query";
        this.desc.projectKey = projectKey;
    }

    @Override
    public Schema getSchema() throws Exception {
        return this.schema;
    }

    @Override
    public ExportInput.InputDescription describe() {
        return this.desc;
    }

    @Override
    public long getInputSize() {
        return -1L;
    }

    @Override
    public void close() {
        if (this.queryRuntime != null) {
            try {
                this.queryRuntime.close(true, false);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to cleanup query", (Throwable)e);
            }
        }
    }

    @Override
    protected void initializeImpl(ExportService.LocalExportJob job, StreamableDatasetSelection selection, ColumnFactory cf) throws SQLException, IOException, InterruptedException, DKUSecurityException {
        this.desc.status = "Executing SQL query...";
        QueryParams qp = new QueryParams();
        qp.connection = this.query.connection;
        qp.sql = this.sql;
        this.queryRuntime = new SQLQueryRuntime(this.projectKey, qp, null, this.authCtx);
        this.queryRuntime.init(-1);
        this.it = this.queryRuntime.iterator(null);
        this.it.init(cf);
        this.schema = this.it.getSchema();
    }

    @Override
    protected void streamImpl(Sampler output) throws Exception {
        this.desc.status = "Downloading SQL query results...";
        Row r = this.it.next();
        int counter = 0;
        while (r != null && !output.sampleIsComplete()) {
            output.emitRow(r);
            r = this.it.next();
            if (++counter % 10000 != 0) continue;
            FutureProgressState.checkInterrupt();
        }
        output.lastRowEmitted();
    }

    @Override
    public FuturePayload.FuturePayloadTarget getSource() {
        return new FuturePayload.FuturePayloadTarget(this.projectKey, this.notebookId, ITaggingService.TaggableType.SQL_NOTEBOOK.name(), this.notebookId).withPart(this.query.mode == SQLNotebookQuery.QueryMode.HIVE ? this.query.hiveQueryId : this.query.id);
    }
}

