/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.export.output;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.export.CustomExporterDesc;
import com.dataiku.dip.export.CustomJavaExportersService;
import com.dataiku.dip.export.ExportService;
import com.dataiku.dip.export.LoadedJavaExporter;
import com.dataiku.dip.export.ZipUnzipDir;
import com.dataiku.dip.export.output.CustomJavaExportOutput;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.log4j.Logger;

public class CustomJavaExportFileOutput
extends CustomJavaExportOutput {
    private File outputFile;
    private AutoDelete tmpZipDir;
    private static Logger logger = Logger.getLogger((String)"dip.javaexporter.output");

    public CustomJavaExportFileOutput(File destinationFilePath, AuthCtx authCtx, String projectKey, JsonObject config, LoadedJavaExporter loaded, CustomJavaExportersService customJavaExporterService) {
        super(authCtx, projectKey, config, loaded, customJavaExporterService);
        this.outputFile = destinationFilePath;
    }

    @Override
    protected File getDestinationFile() {
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.FILE_OR_STREAM_TO_GZIP) {
            return new File(this.outputFile.getParentFile(), "temp.out");
        }
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.DIR_TO_ZIP) {
            return this.tmpZipDir;
        }
        return this.outputFile;
    }

    @Override
    public void initialize(ExportService.LocalExportJob job, Schema schema, ColumnFactory cf) throws Exception {
        DKUFileUtils.mkdirsParent((File)this.outputFile);
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.DIR_TO_ZIP) {
            this.tmpZipDir = FlowJobUtils.getTmpFolder("java-exporter", "exporterout");
            DKUFileUtils.mkdirs((File)this.tmpZipDir);
        }
        super.initialize(job, schema, cf);
    }

    @Override
    public long getWrittenBytes() throws Exception {
        return this.outputFile.length();
    }

    @Override
    public void close() {
        super.close();
        if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.FILE_OR_STREAM_TO_GZIP) {
            File tempFile = new File(this.outputFile.getParentFile(), "temp.out");
            try (FileInputStream fis = new FileInputStream(tempFile);
                 FileOutputStream fos = new FileOutputStream(this.outputFile);
                 GZIPOutputStream gos = new GZIPOutputStream(fos);){
                IOUtils.copy((InputStream)fis, (OutputStream)gos);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to compress export output", (Throwable)e);
            }
        } else if (this.loaded.getCompression() == CustomExporterDesc.ExportCompression.DIR_TO_ZIP) {
            try {
                ZipUnzipDir.zipDirectory((File)this.tmpZipDir, this.outputFile);
            }
            catch (IOException e) {
                logger.error((Object)"Failed to compress export output", (Throwable)e);
            }
        }
        if (this.tmpZipDir != null) {
            this.tmpZipDir.close();
        }
    }
}

