/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.exposition;

import com.dataiku.dip.autorestart.AutoRestartingProcessRunner;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.DkuComponentMetadata;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.exposition.Exposables;
import com.dataiku.dip.exposition.ExposedEndpointConsumer;
import com.dataiku.dip.exposition.Exposition;
import com.dataiku.dip.exposition.ExpositionDesc;
import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.exposition.ExpositionMeta;
import com.dataiku.dip.exposition.ExpositionParams;
import com.dataiku.dip.futures.IStateLabelAggregator;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppSecurityInfo;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.bokeh.BokehWebAppMeta;
import com.dataiku.dip.webapps.dash.DashWebAppMeta;
import com.dataiku.dip.webapps.plugins.CustomWebAppMeta;
import com.dataiku.dip.webapps.proxy.ProxyWebAppMeta;
import com.dataiku.dip.webapps.shiny.ShinyWebAppMeta;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class LocalProcessExposition {
    public static final ExpositionMeta META = new ExpositionMeta(){

        @Override
        public String getType() {
            return "local_process";
        }

        @Override
        public Class<? extends ExpositionParams> getParamsClass() {
            return LocalProcessExpositionParams.class;
        }

        @Override
        public ExpositionDesc getDesc(ExpositionMeta.ExpositionUsageContext usageContext) {
            return new ExpositionDesc().withType(this.getType()).withMeta(new DkuComponentMetadata("Local process", "Backend running on same machine as DSS", null, null));
        }

        @Override
        public ExpositionHandler buildHandler(AuthCtx authCtx, String projectKey, ContainerExecRuntimeConfig containerConfig, Exposition exposition, ExposedEndpointConsumer endpointConsumer) {
            LocalProcessExpositionParams params = exposition.getParamsAs(LocalProcessExpositionParams.class);
            return new LocalProcessExpositionHandler(endpointConsumer, params);
        }

        @Override
        public long getMaxStartWait(AuthCtx authCtx) {
            return 60000L;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig containerConfig) {
            return containerConfig == null || containerConfig.type == null;
        }

        @Override
        public boolean handles(Exposables.ExposableKind kind) {
            return kind == Exposables.ExposableKind.WEBAPP;
        }

        @Override
        public boolean handles(ContainerExecRuntimeConfig.Container containerType) {
            return containerType == null;
        }

        @Override
        public void expandParametersInPlace(VariablesContext vc, Exposition exposition) {
        }
    };
    private static Logger logger = Logger.getLogger((String)"dip.webapp.exposition.local");

    private static class LocalProcessExpositionHandler
    implements ExpositionHandler {
        private final ExposedEndpointConsumer endpointConsumer;
        private DKUtils.TagSniffingLineSubscription startSniffer;
        private WebAppSecurityInfo securityInfo;
        private boolean closed;
        private ExpositionHandler.ExpositionStatus status = new ExpositionHandler.ExpositionStatus();
        private int webAppPort;

        LocalProcessExpositionHandler(ExposedEndpointConsumer endpointConsumer, LocalProcessExpositionParams params) {
            this.endpointConsumer = endpointConsumer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleanup() {
            this.closed = true;
            if (this.startSniffer != null) {
                DKUtils.TagSniffingLineSubscription tagSniffingLineSubscription = this.startSniffer;
                synchronized (tagSniffingLineSubscription) {
                    this.startSniffer.notifyAll();
                }
            }
        }

        @Override
        public void init(Exposables.Exposable exposable, IStateLabelAggregator stateLabelAggregator) throws IOException {
            String pattern;
            Exposables.LocalExposable localExposable = (Exposables.LocalExposable)exposable;
            WebAppBackend backend = (WebAppBackend)this.endpointConsumer;
            WebAppMeta meta = backend.getWebAppMeta();
            String metaType = meta instanceof CustomWebAppMeta ? ((CustomWebAppMeta)meta).getBaseType() : meta.getType();
            this.securityInfo = localExposable.getSecurityInfo();
            ArrayList removed = Lists.newArrayList();
            ArrayList added = Lists.newArrayList();
            ArrayList modified = Lists.newArrayList();
            if (StandardWebAppMeta.META.getType().equals(metaType) || ProxyWebAppMeta.META.getType().equals(metaType)) {
                pattern = "^.*Started backend on port ([0-9]+)\\s*$";
                if (this.securityInfo.backendCheckAccess) {
                    added.add(Lists.newArrayList((Object[])new String[]{"127.0.0.1"}));
                    localExposable.alterCommandLine(removed, modified, added);
                }
            } else if (ShinyWebAppMeta.META.getType().equals(metaType)) {
                pattern = "^.*Listening on [^:]+://[^:]+:([0-9]+)\\s*$";
                if (this.securityInfo.backendCheckAccess) {
                    modified.add(new SimpleKeyValue("runApp\\((.*)\\)", "runApp($1, host=\"127.0.0.1\")"));
                    localExposable.alterCommandLine(removed, modified, added);
                }
            } else if (BokehWebAppMeta.META.getType().equals(metaType)) {
                pattern = "^.*Bokeh app running at: [^:]+://[^:]+:([0-9]+)(/backend)?\\s*$";
                added.add(Lists.newArrayList((Object[])new String[]{"127.0.0.1", "0"}));
                localExposable.alterCommandLine(removed, modified, added);
            } else if (DashWebAppMeta.META.getType().equals(metaType)) {
                pattern = "^.*Started Dash on port ([0-9]+)\\s*$";
                added.add(Lists.newArrayList((Object[])new String[]{"127.0.0.1"}));
                localExposable.alterCommandLine(removed, modified, added);
            } else {
                pattern = ".*port.*([0-9]+)";
            }
            this.startSniffer = new DKUtils.TagSniffingLineSubscription(Pattern.compile(pattern)){

                protected void handleTag(String line, Matcher matcher) {
                    super.handleTag(line, matcher);
                    try {
                        webAppPort = Integer.parseInt(matcher.group(1));
                        ExposedEndpointConsumer.ExposedEndpoint endpoint = new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, null, webAppPort, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
                        endpointConsumer.registerPort(endpoint);
                        status.endpoints.add(endpoint);
                        status.isHealthy = true;
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to register port for webapp backend", (Throwable)e);
                    }
                }
            };
            DKUtils.ExecOutputConsumer execOutputConsumer = localExposable.getExecOutputConsumer();
            execOutputConsumer.withOutputConsumer((DKUtils.ExecSubscription)this.startSniffer);
            execOutputConsumer.withErrorConsumer((DKUtils.ExecSubscription)this.startSniffer);
        }

        @Override
        public void start(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void waitReady(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws AutoRestartingProcessRunner.BackendStartFailedException, InterruptedException {
            logger.info((Object)"Start waiting for starting line in webapp logs");
            while (!this.closed && !this.startSniffer.hasFoundTag()) {
                DKUtils.TagSniffingLineSubscription tagSniffingLineSubscription = this.startSniffer;
                synchronized (tagSniffingLineSubscription) {
                    this.startSniffer.wait();
                }
                if (!this.startSniffer.isClosed()) continue;
                throw new AutoRestartingProcessRunner.BackendStartFailedException("Sniffer was closed. Likely, kernel died before the start tag could be read in the logs", null, null);
            }
            logger.info((Object)"Found the starting line in webapp logs");
        }

        @Override
        public ExpositionHandler.ExpositionStatus getStatus(DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) throws Exception {
            return this.closed ? new ExpositionHandler.ExpositionStatus() : this.status;
        }

        @Override
        public ExposedEndpointConsumer.ExposedEndpoint getExpectedExposedEndpoint() {
            return new ExposedEndpointConsumer.ExposedEndpoint(META.getType(), null, null, null, this.webAppPort, null, ExposedEndpointConsumer.ExposedEndpointAvailability.LOCAL);
        }
    }

    public static class LocalProcessExpositionParams
    implements ExpositionParams {
    }
}

