/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.externalinfras.snowpark.datamodel;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SnowparkServiceStatus {
    @Nonnull
    public final String status;
    @Nonnull
    public final String message;
    public final int restartCount;

    public SnowparkServiceStatus(@Nonnull String status, @Nonnull String message, int restartCount) {
        this.status = status;
        this.message = message;
        this.restartCount = restartCount;
    }

    @Nullable
    public static SnowparkServiceStatus getWorse(@Nullable List<SnowparkServiceStatus> statuses) {
        if (statuses == null || statuses.isEmpty()) {
            return null;
        }
        if (statuses.size() == 1) {
            return statuses.get(0);
        }
        ArrayList orderedProblematicStatus = Lists.newArrayList((Object[])new String[]{"FAILED", "PENDING", "UNKNOWN"});
        for (String ref : orderedProblematicStatus) {
            Optional<SnowparkServiceStatus> refStatus = statuses.stream().filter(s -> s.status.equalsIgnoreCase(ref)).findFirst();
            if (!refStatus.isPresent()) continue;
            return refStatus.get();
        }
        Optional<SnowparkServiceStatus> undocumentedStatus = statuses.stream().filter(s -> !s.status.equalsIgnoreCase("READY")).findFirst();
        return undocumentedStatus.orElse(statuses.get(0));
    }
}

