/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.formats.custom;

import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.custom.IElementLoadedDesc;
import com.dataiku.dip.custom.IPluginifiedMeta;
import com.dataiku.dip.datasets.SchemaDetection;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.FormatMeta;
import com.dataiku.dip.formats.custom.CustomPythonFormatDesc;
import com.dataiku.dip.formats.custom.CustomPythonFormatExtractor;
import com.dataiku.dip.formats.custom.CustomPythonFormatParams;
import com.dataiku.dip.formats.custom.CustomPythonFormatWithSchemaExtractor;
import com.dataiku.dip.formats.custom.CustomPythonFormatsService;
import com.dataiku.dip.formats.custom.CustomPythonOutputFormatter;
import com.dataiku.dip.formats.custom.LoadedPythonFormat;
import com.dataiku.dip.input.formats.FormatExtractor;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.ParamDesc;
import org.apache.commons.lang.StringUtils;

public class CustomPythonFormatMeta
extends FormatMeta<CustomPythonFormatExtractor, CustomPythonFormatParams>
implements IPluginifiedMeta {
    private final LoadedPythonFormat loaded;
    private final CustomPythonFormatsService service;

    public CustomPythonFormatMeta(LoadedPythonFormat loaded, CustomPythonFormatsService service) {
        this.loaded = loaded;
        this.service = service;
    }

    public boolean canBeDatasetFormat() {
        return ((CustomPythonFormatDesc)this.loaded.getDesc()).canBeDatasetFormat;
    }

    @Override
    public String getType() {
        return this.loaded.getType();
    }

    @Override
    public String getLabel() {
        if (((CustomPythonFormatDesc)this.loaded.desc).meta != null && StringUtils.isNotBlank((String)((CustomPythonFormatDesc)this.loaded.desc).meta.label)) {
            return ((CustomPythonFormatDesc)this.loaded.desc).meta.label;
        }
        return "Custom format " + this.loaded.getId() + " (" + this.loaded.getOwnerPluginId() + ")";
    }

    @Override
    public SchemaDetection.SchemaHandlingType getSchemaHandlingType() {
        return SchemaDetection.SchemaHandlingType.NAME_BASED_VARIABLE_COLUMNS;
    }

    @Override
    public ParamDesc[] getParams() {
        ParamDesc param = new ParamDesc("config", "autoconfig");
        param.params = ((CustomPythonFormatDesc)this.loaded.desc).params;
        return new ParamDesc[]{param, FormatFactory.getStandardCompressionMethods()};
    }

    @Override
    public Class<? extends FormatParams> paramsClass() {
        return CustomPythonFormatParams.class;
    }

    @Override
    public FormatExtractor build(AuthCtx authCtx, String projectKey, FormatParams params) {
        CustomPythonFormatParams pyParams = (CustomPythonFormatParams)params;
        if (((CustomPythonFormatDesc)this.loaded.desc).canExtractSchema) {
            return new CustomPythonFormatWithSchemaExtractor(authCtx, projectKey, pyParams.config, this.loaded, this.service);
        }
        return new CustomPythonFormatExtractor(authCtx, projectKey, pyParams.config, this.loaded, this.service);
    }

    @Override
    public OutputFormatter buildFormatter(AuthCtx authCtx, String projectKey, FormatParams params) {
        CustomPythonFormatParams pyParams = (CustomPythonFormatParams)params;
        return new CustomPythonOutputFormatter(authCtx, projectKey, pyParams.config, this.loaded, this.service);
    }

    @Override
    public IElementLoadedDesc getLoadedDesc() {
        return this.loaded;
    }
}

