/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.formats.hive.rcfile;

import com.dataiku.dip.input.formats.BinaryHeader;
import com.dataiku.dip.input.formats.InputFormatsDetector;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatConfig;
import com.dataiku.dip.input.formats.hive.rcfile.RCFileFormatMeta;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;

public class RCFileFormatDetector {
    private static final byte[] RCFILE_MAGIC = new byte[]{82, 67, 70};

    public Collection<? extends InputFormatsDetector.FormatWithMetadata> detect(BinaryHeader header) {
        if (header.bytes.length < 3) {
            return Collections.emptyList();
        }
        if (Arrays.equals(RCFILE_MAGIC, Arrays.copyOfRange(header.bytes, 0, 3))) {
            InputFormatsDetector.FormatWithMetadata fwm = new InputFormatsDetector.FormatWithMetadata();
            fwm.detectionScore = 600.0;
            fwm.params = new RCFileFormatConfig();
            fwm.type = RCFileFormatMeta.META.getType();
            fwm.metadata = new HashMap<String, String>();
            return Arrays.asList(fwm);
        }
        return Collections.emptyList();
    }
}

