/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.input.stream;

import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import com.dataiku.dip.input.stream.StreamsInputSplit;
import com.dataiku.dip.partitioning.FileBucket;
import com.dataiku.dip.partitioning.FilePartition;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ParallelStreamer {
    private AbstractFSDatasetHandler handler;
    private List<FilePartition> partitions;
    private int nthreads;
    private LinkedBlockingQueue<PathAndPartition> queue;
    private int acquiredRunners;
    private static final PathAndPartition poison = new PathAndPartition();
    int doneRunner = 0;
    private static Logger logger = Logger.getLogger((String)"dku.flow.stream");

    public ParallelStreamer(AbstractFSDatasetHandler handler, List<FilePartition> partitions, int nthreads) {
        this.partitions = partitions;
        this.nthreads = nthreads;
        this.handler = handler;
        int totalFiles = 0;
        for (FilePartition fp : partitions) {
            totalFiles += fp.getNbFiles();
            logger.debug((Object)("ADD PARTITION " + String.valueOf((Object)fp) + " files: " + fp.getNbFiles()));
        }
        this.queue = new LinkedBlockingQueue(totalFiles + nthreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        for (FilePartition fp : this.partitions) {
            for (FileBucket fb : fp.buckets) {
                for (FSPath p : fb.paths) {
                    PathAndPartition pandp = new PathAndPartition();
                    pandp.path = p;
                    pandp.partition = fp;
                    if (p != null) {
                        logger.debug((Object)("Offering " + p.path() + " for runners to take"));
                    }
                    this.queue.put(pandp);
                }
            }
        }
        logger.info((Object)"Offering poison");
        for (int i = 0; i < this.nthreads; ++i) {
            this.queue.put(poison);
        }
        logger.info((Object)"Done offering, waiting for all runners to finish");
        ParallelStreamer parallelStreamer = this;
        synchronized (parallelStreamer) {
            while (this.doneRunner < this.nthreads) {
                logger.info((Object)("Have " + this.doneRunner + " done - nthreads " + this.nthreads));
                this.wait();
            }
        }
        logger.info((Object)"Parallel streamer done");
    }

    public synchronized SplitRunner getRunner(int runner) {
        assert (runner < this.nthreads);
        assert (this.acquiredRunners < this.nthreads);
        ++this.acquiredRunners;
        return new SplitRunner();
    }

    private synchronized void runnerDone() {
        ++this.doneRunner;
        this.notifyAll();
    }

    private synchronized void runnerFailed() {
        ++this.doneRunner;
        this.notifyAll();
    }

    static class PathAndPartition {
        FSPath path;
        FilePartition partition;

        PathAndPartition() {
        }
    }

    public class SplitRunner
    extends StreamsInputSplit {
        private boolean done;

        public String getDesc() {
            return null;
        }

        public void cancel() {
            if (!this.done) {
                ParallelStreamer.this.runnerFailed();
            }
        }

        public EnrichedInputStream nextStream() throws IOException, InterruptedException, DKUSecurityException, CodedException {
            PathAndPartition pandp;
            try {
                pandp = ParallelStreamer.this.queue.poll(1000L, TimeUnit.DAYS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException(e);
            }
            if (pandp.path == null) {
                logger.info((Object)"Split runner done");
                this.done = true;
                ParallelStreamer.this.runnerDone();
                return null;
            }
            logger.info((Object)("Split runner has work to do : " + pandp.path.path()));
            return ParallelStreamer.this.handler.getStream(pandp.path, pandp.partition);
        }

        public void reset() {
            throw new IllegalArgumentException("Parallel stream split is not resetable");
        }
    }
}

