/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.analysis.ml.distributed.workers.WorkerPool;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.io.PythonSecretProtectedKernel;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.io.SocketBlockLink;
import com.dataiku.dip.io.SocketBlockLinkInteraction;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.process.InsecureProcessesLaunchService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.security.process.RegularProcess;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.annotations.VisibleForTesting;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractImpersonableSecretProtectedPythonKernel<L extends SecretProtectedKernelLink>
extends PythonSecretProtectedKernel<L> {
    @VisibleForTesting
    public final APITicketService.Ticket ticket;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.python.plugin");

    public AbstractImpersonableSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, APITicketService.Ticket ticket, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonlibs, File workDir, boolean impersonate, String projectKey, AuthCtx authCtx, String envName) {
        this(link, cgrouppableProcessType, ticket, resourceFolderPath, useProjectLibs, pythonlibs, workDir, impersonate, projectKey, authCtx, envName, null);
    }

    public AbstractImpersonableSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, APITicketService.Ticket ticket, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonlibs, File workDir, boolean impersonate, String projectKey, AuthCtx authCtx, String envName, WorkerPool workerPool) {
        super(authCtx, link, resourceFolderPath, useProjectLibs, pythonlibs, projectKey, envName, impersonate, workDir, cgrouppableProcessType, workerPool);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public AbstractImpersonableSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, APITicketService.Ticket ticket, String resourceFolderPath, boolean useProjectLibs, Map<String, String> pythonlibs, File workDir, boolean impersonate, String projectKey, AuthCtx authCtx, String envName, WorkerPool workerPool, String kernelId) {
        super(authCtx, link, resourceFolderPath, useProjectLibs, pythonlibs, projectKey, envName, impersonate, workDir, cgrouppableProcessType, workerPool, kernelId);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    public AbstractImpersonableSecretProtectedPythonKernel(L link, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType, APITicketService.Ticket ticket, String resourceFolderPath, Map<String, String> pythonlibs, File workDir, boolean impersonate, String projectKey, AuthCtx authCtx, String envName) {
        super(authCtx, link, resourceFolderPath, false, pythonlibs, projectKey, envName, impersonate, workDir, cgrouppableProcessType);
        this.ticket = ticket;
        SpringUtils.getInstance().autowire((Object)this);
    }

    @Override
    protected IsolableProcess createAndStartProcess(ProcessBuilder pb, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) throws DKUSecurityException, IOException, InterruptedException {
        if (this.ticket != null) {
            pb.environment().put("DKU_API_TICKET", this.ticket.getSecret());
        }
        if (JobContext.getCurrentActivity() != null) {
            pb.environment().put("DKU_JOB_ACTIVITY_ID", JobContext.getCurrentActivity());
        }
        if (this.impersonated) {
            InsecureProcessesLaunchService insecureProcessesLaunchService = (InsecureProcessesLaunchService)SpringUtils.getBean(InsecureProcessesLaunchService.class);
            return insecureProcessesLaunchService.launch(this.authCtx, this.projectKey, cgrouppableProcessType, this.workDir, pb);
        }
        RegularProcess p = new RegularProcess(pb, this.workDir, cgrouppableProcessType, this.authCtx, this.projectKey);
        p.start();
        return p;
    }

    public static abstract class LoopWithProgress<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runUntilDone(String objectType, SecretProtectedKernelLink link, DSSKernelBase kernel) throws IOException, InterruptedException {
            try (FutureProgress.AutocloseableFutureProgressState state = null;){
                boolean done = false;
                while (!done) {
                    PythonMessageNotification incomingType = (PythonMessageNotification)link.receiveJsonResponse(PythonMessageNotification.class);
                    if (incomingType == null) {
                        throw SocketBlockLinkInteraction.throwExceptionFromPython((SocketBlockLink)link, (String)("Failed to run " + objectType));
                    }
                    logger.info((Object)("Python sends " + JSON.json((Object)incomingType)));
                    switch (incomingType.type) {
                        case PROGRESS_INFO: {
                            if (state != null) {
                                throw ErrorContext.iae((String)"The type and target of the progress can only be set once");
                            }
                            ProgressInfo progressInfo = (ProgressInfo)link.receiveJsonResponse(ProgressInfo.class);
                            if (StringUtils.isBlank((String)progressInfo.name)) {
                                progressInfo.name = "Python execution";
                            }
                            if (progressInfo.unit == null) {
                                progressInfo.unit = FutureProgressState.StateUnit.NONE;
                            }
                            if (progressInfo.target == 0L) {
                                progressInfo.target = -1L;
                            }
                            state = FutureProgress.pushAutoCloseableState((String)progressInfo.name, (double)progressInfo.target, (FutureProgressState.StateUnit)progressInfo.unit);
                            break;
                        }
                        case PROGRESS_CHANGE: {
                            if (state == null) {
                                throw ErrorContext.iae((String)"Progress info cannot be reported without having set the progress info first");
                            }
                            ProgressChange progressChange = (ProgressChange)link.receiveJsonResponse(ProgressChange.class);
                            state.set(progressChange.current);
                            break;
                        }
                        case ERROR: {
                            this.handleError(link, kernel);
                            done = true;
                            break;
                        }
                        case RESULT: {
                            this.handleResult(link, kernel);
                            done = true;
                        }
                    }
                }
            }
        }

        protected abstract void handleError(SecretProtectedKernelLink var1, DSSKernelBase var2) throws IOException;

        protected abstract void handleResult(SecretProtectedKernelLink var1, DSSKernelBase var2) throws IOException;

        public abstract PythonError getError();

        public abstract T getResult();
    }

    public static class PythonError {
        String errorType;
        String message;
        JsonArray traceback;

        public WarningsContext.SerializedThrowable getSerializedThrowable() {
            if (StringUtils.isNotBlank((String)this.errorType)) {
                WarningsContext.SerializedThrowable error = new WarningsContext.SerializedThrowable(this.errorType + " : " + this.message);
                error.clazz = "PackagedPythonException";
                if (this.traceback != null) {
                    StringBuilder sb = new StringBuilder();
                    for (JsonElement traceElement : this.traceback) {
                        JsonArray traceElementArray = traceElement.getAsJsonArray();
                        String file = traceElementArray.size() >= 1 && !traceElementArray.get(0).isJsonNull() ? traceElementArray.get(0).getAsString() : null;
                        int line = traceElementArray.size() >= 2 && !traceElementArray.get(1).isJsonNull() ? traceElementArray.get(1).getAsInt() : 0;
                        String function = traceElementArray.size() >= 3 && !traceElementArray.get(2).isJsonNull() ? traceElementArray.get(2).getAsString() : "";
                        String text = traceElementArray.size() >= 4 && !traceElementArray.get(3).isJsonNull() ? traceElementArray.get(3).getAsString() : "";
                        sb.append(file + " : " + function + " (" + line + ")\n");
                        sb.append("\t" + text + "\n");
                    }
                    error.stack = sb.toString();
                }
                return error;
            }
            return null;
        }
    }

    public static class ProgressChange {
        public double current;
    }

    public static class ProgressInfo {
        public String name;
        public long target;
        public FutureProgressState.StateUnit unit;
    }

    public static class PythonMessageNotification {
        public PythonMessageType type;
    }

    public static enum PythonMessageType {
        PROGRESS_INFO,
        PROGRESS_CHANGE,
        RESULT,
        ERROR;

    }
}

