/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.io.BinaryUtils;
import com.google.common.io.ByteStreams;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class BinaryStreamDecoder
implements AutoCloseable {
    private byte[] buffer = new byte[10];
    private InputStream is;

    public BinaryStreamDecoder(InputStream is) {
        this.is = is;
    }

    public int readLE32() throws IOException {
        ByteStreams.readFully((InputStream)this.is, (byte[])this.buffer, (int)0, (int)4);
        return BinaryUtils.decodeLE32(this.buffer, 0);
    }

    public int readUInt8() throws IOException {
        ByteStreams.readFully((InputStream)this.is, (byte[])this.buffer, (int)0, (int)1);
        return BinaryUtils.decodeUInt8(this.buffer, 0);
    }

    public int readBE32() throws IOException {
        ByteStreams.readFully((InputStream)this.is, (byte[])this.buffer, (int)0, (int)4);
        return BinaryUtils.decodeBE32(this.buffer, 0);
    }

    public int readBE16() throws IOException {
        ByteStreams.readFully((InputStream)this.is, (byte[])this.buffer, (int)0, (int)2);
        return BinaryUtils.decodeBE16(this.buffer, 0);
    }

    public void readRawDoubleBlock(int nb, double[] buf) throws IOException {
        byte[] b = new byte[nb * 8];
        ByteStreams.readFully((InputStream)this.is, (byte[])b, (int)0, (int)(nb * 8));
        for (int i = 0; i < nb; ++i) {
            long lng = BinaryUtils.decodeLE64(b, 8 * i);
            buf[i] = Double.longBitsToDouble(lng);
        }
    }

    public String readUTF8(int lengthInBytes) throws IOException {
        byte[] b = new byte[lengthInBytes];
        ByteStreams.readFully((InputStream)this.is, (byte[])b);
        return new String(b, StandardCharsets.UTF_8);
    }

    public byte readByte() throws IOException {
        int i = this.is.read();
        if (i == -1) {
            throw new EOFException();
        }
        return (byte)i;
    }

    public long readVIntSlow() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readByte();
            long lb = b >= 0 ? (long)b : 256L + (long)b;
            result |= lb >> 1 << shift;
            if ((lb & 1L) != 0L) continue;
            return result;
        }
        throw new Error("Malformed Vint");
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
            this.is = null;
        }
    }
}

