/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.io;

import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.io.KernelUtils;
import com.dataiku.dip.io.SecretProtectedKernelLink;
import com.dataiku.dip.kernels.DSSKernelBase;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.IImpersonationResolverService;
import com.dataiku.dip.security.process.IsolableProcess;
import com.dataiku.dip.server.SpringUtils;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class RSecretProtectedKernel<L extends SecretProtectedKernelLink>
extends DSSKernelBase {
    private final boolean useProjectLibs;
    protected final L link;
    protected final String envName;
    protected final String projectKey;
    protected final boolean impersonated;
    protected final File workDir;
    protected final AuthCtx authCtx;
    protected final GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType;
    private final IImpersonationResolverService impersonationResolverService;
    protected final Map<String, String> kernelEnvVariables = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger((String)"dku.r.single_command.kernel");

    protected RSecretProtectedKernel(AuthCtx authCtx, L link, boolean useProjectLibs, String projectKey, String envName, boolean impersonated, File workDir, GeneralSettingsDAO.CGrouppableProcessType cgrouppableProcessType) {
        super("r-single-command-kernel");
        this.authCtx = authCtx;
        this.link = link;
        this.useProjectLibs = useProjectLibs;
        this.projectKey = projectKey;
        this.envName = envName;
        this.cgrouppableProcessType = cgrouppableProcessType;
        this.impersonated = impersonated;
        this.workDir = workDir;
        this.impersonationResolverService = impersonated ? (IImpersonationResolverService)SpringUtils.getBean(IImpersonationResolverService.class) : null;
        if (StringUtils.isNotBlank((String)projectKey) && !"__DKU_ANY_PROJECT__".equals(projectKey)) {
            this.kernelEnvVariables.put("DKU_CURRENT_PROJECT_KEY", projectKey);
        }
    }

    protected abstract String getRScript() throws IOException;

    protected List<String> getRCmd() {
        ArrayList<String> cmd = new ArrayList<String>();
        String rBin = System.getenv("DKURBIN");
        if (rBin == null) {
            throw new Error("environment variable DKURBIN not defined");
        }
        cmd.add(new File(rBin).getAbsolutePath());
        return cmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        List<String> args = this.getRCmd();
        args.add("--no-save");
        args.add("--args");
        args.add(String.valueOf(this.link.getPort()));
        args.add(this.link.getSecret());
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.environment().putAll(this.kernelEnvVariables);
        boolean impersonate = this.impersonationResolverService != null && this.impersonationResolverService.isEnabled();
        KernelUtils.handlePythonAndRPath(this.authCtx, this.projectKey, this.useProjectLibs, null, this.workDir, impersonate, pb);
        logger.info((Object)("Starting R process for kernel  " + this.getId()));
        this.process = this.createAndStartProcess(pb);
        this.startStandardTailers();
        this.outputConsumer.withInput(this.getRScript());
        this.monitorThread = new DSSKernelBase.KernelMonitorThread((DSSKernelBase)this);
        if (this.cgrouppableProcessType != null) {
            this.monitorThread.enableComputeResourceUsageReporting(args.get(0));
        }
        this.monitorThread.setCloseOnFailure((Closeable)this.link.getServerSocket());
        try {
            this.monitorThread.start();
            this.link.waitForProcess();
        }
        finally {
            this.monitorThread.setCloseOnFailure(null);
        }
    }

    protected abstract IsolableProcess createAndStartProcess(ProcessBuilder var1) throws DKUSecurityException, IOException, InterruptedException;

    public Integer getPid() {
        if (this.process != null) {
            return this.process.getWorkingPid();
        }
        return null;
    }
}

