/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online;

import com.dataiku.dip.analysis.ml.llm.LLMSMMgmtService;
import com.dataiku.dip.analysis.ml.llm.SavedLLMModelHandle;
import com.dataiku.dip.analysis.model.llm.LLMModelSnippetData;
import com.dataiku.dip.cluster.ClusterSelector;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.connections.AnthropicConnection;
import com.dataiku.dip.connections.AzureLLMConnection;
import com.dataiku.dip.connections.AzureOpenAIConnection;
import com.dataiku.dip.connections.BedrockConnection;
import com.dataiku.dip.connections.CohereConnection;
import com.dataiku.dip.connections.ConnectionWithBasicCredential;
import com.dataiku.dip.connections.ConnectionWithGoogleAuthCredentials;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.CustomLLMConnection;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.DatabricksLLMConnection;
import com.dataiku.dip.connections.HuggingFaceInferenceAPIConnection;
import com.dataiku.dip.connections.HuggingFaceLocalConnection;
import com.dataiku.dip.connections.MistralAIConnection;
import com.dataiku.dip.connections.NvidiaNimConnection;
import com.dataiku.dip.connections.OpenAIConnection;
import com.dataiku.dip.connections.SageMakerGenericLLMConnection;
import com.dataiku.dip.connections.SnowflakeCortexLLMConnection;
import com.dataiku.dip.connections.StabilityAIConnection;
import com.dataiku.dip.connections.VertexAILLMConnection;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.dao.SavedModelsDAO;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.llm.LLMModelHandle;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.custom.CustomLLMTypesRegistry;
import com.dataiku.dip.llm.langchain.PluginAgentLLMClient;
import com.dataiku.dip.llm.langchain.PythonAgentLLMClient;
import com.dataiku.dip.llm.langchain.ToolsUsingAgentLLMClient;
import com.dataiku.dip.llm.local.HuggingFaceKernelPool;
import com.dataiku.dip.llm.online.AbstractLLMClient;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientCostLimitingWrapper;
import com.dataiku.dip.llm.online.LLMCostLimitingService;
import com.dataiku.dip.llm.online.anthropic.AnthropicClient;
import com.dataiku.dip.llm.online.azuremlgeneric.AzureLLMClient;
import com.dataiku.dip.llm.online.bedrock.BedrockClient;
import com.dataiku.dip.llm.online.cohere.CohereClient;
import com.dataiku.dip.llm.online.databricks.DatabricksLLMClient;
import com.dataiku.dip.llm.online.huggingface.HuggingFaceInferenceAPIClient;
import com.dataiku.dip.llm.online.mistralai.MistralAIClient;
import com.dataiku.dip.llm.online.nvidia.NvidiaNimClient;
import com.dataiku.dip.llm.online.openai.AzureOpenAIClient;
import com.dataiku.dip.llm.online.openai.OpenAIClient;
import com.dataiku.dip.llm.online.sagemakergeneric.SageMakerLLMClient;
import com.dataiku.dip.llm.online.snowflakecortex.SnowflakeCortexLLMClient;
import com.dataiku.dip.llm.online.stabilityai.StabilityAIClient;
import com.dataiku.dip.llm.online.vertex.VertexClient;
import com.dataiku.dip.llm.retrieval.RAGKernelPool;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.rpc.TicketBasedIntercomAPIClient;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.model.ICredentialsService;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.IsolationLevel;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class LLMClientFactory {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.client.factory");

    private static void checkLLMAvailableInConnection(LLMStructuredRef identifier, AbstractLLMConnection<?, ?, ?> connection) {
        if (connection.listAvailableLLMStructuredRefs(null).stream().noneMatch(ref -> Objects.equals((Object)ref.type, (Object)identifier.type) && Objects.equals(ref.id, identifier.id))) {
            throw new IllegalArgumentException(String.format("LLM %s is not available for connection %s", identifier.id, connection.name));
        }
    }

    public static LLMClient getRemoteLLM_NoCheck(AuthCtx authCtx, @Nullable String projectKey, LLMStructuredRef identifier, AbstractLLMConnection connection) throws Exception {
        ConnectionWithBasicCredential.CredentialResolutionContext ctx = new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, null);
        switch (connection.type) {
            case "AzureOpenAI": {
                AzureOpenAIConnection azureConnection = (AzureOpenAIConnection)connection;
                return new AzureOpenAIClient(azureConnection, azureConnection.getLLMModel(identifier), authCtx, projectKey);
            }
            case "OpenAI": {
                OpenAIConnection openAIConnection = (OpenAIConnection)connection;
                ICredentialsService.BasicCredential openAICreds = connection.getFullyResolvedCredentials_fsLike(ctx, ICredentialsService.BasicCredential.class);
                return new OpenAIClient(openAIConnection, openAIConnection.getLLMModel(identifier), openAICreds.password, projectKey, authCtx);
            }
            case "HuggingFaceInferenceAPI": {
                HuggingFaceInferenceAPIConnection hfConnection = (HuggingFaceInferenceAPIConnection)connection;
                ICredentialsService.BasicCredential hfCreds = hfConnection.getFullyResolvedCredentials_fsLike(ctx, ICredentialsService.BasicCredential.class);
                return new HuggingFaceInferenceAPIClient(hfConnection, hfConnection.getLLMModel(identifier), hfCreds.password);
            }
            case "Cohere": {
                CohereConnection cohereConnection = (CohereConnection)connection;
                ICredentialsService.BasicCredential cohereCreds = cohereConnection.getFullyResolvedCredentials_fsLike(ctx, ICredentialsService.BasicCredential.class);
                return new CohereClient(cohereConnection, cohereConnection.getLLMModel(identifier), cohereCreds.password);
            }
            case "Anthropic": {
                AnthropicConnection anthropicConnection = (AnthropicConnection)connection;
                ICredentialsService.BasicCredential anthropicCreds = anthropicConnection.getFullyResolvedCredentials_fsLike(ctx, ICredentialsService.BasicCredential.class);
                return new AnthropicClient(anthropicConnection, anthropicConnection.getLLMModel(identifier), anthropicCreds.password);
            }
            case "MistralAI": {
                MistralAIConnection mistralAIConnection = (MistralAIConnection)connection;
                ICredentialsService.BasicCredential mistralAICreds = mistralAIConnection.getFullyResolvedCredentials_fsLike(ctx, ICredentialsService.BasicCredential.class);
                return new MistralAIClient(mistralAIConnection, mistralAIConnection.getLLMModel(identifier), mistralAICreds.password);
            }
            case "Bedrock": {
                BedrockConnection bedrockConnection = (BedrockConnection)connection;
                return new BedrockClient(authCtx, bedrockConnection, bedrockConnection.getLLMModel(identifier));
            }
            case "MosaicML": {
                throw new UnsupportedOperationException("MosaicML connection is no longer available. Please use a Databricks Mosaic AI connection instead.");
            }
            case "DatabricksLLM": {
                DatabricksLLMConnection databricksLLMConnection = (DatabricksLLMConnection)connection;
                return new DatabricksLLMClient(authCtx, databricksLLMConnection, databricksLLMConnection.getLLMModel(identifier));
            }
            case "SnowflakeCortex": {
                SnowflakeCortexLLMConnection sfcxConnection = (SnowflakeCortexLLMConnection)connection;
                return new SnowflakeCortexLLMClient(authCtx, projectKey, sfcxConnection, sfcxConnection.getLLMModel(identifier));
            }
            case "StabilityAI": {
                StabilityAIConnection stabilityAIConnection = (StabilityAIConnection)connection;
                stabilityAIConnection.ensureDecrypted();
                return new StabilityAIClient(authCtx, stabilityAIConnection, stabilityAIConnection.getLLMModel(identifier));
            }
            case "VertexAILLM": {
                VertexAILLMConnection vertexAILLMConnection = (VertexAILLMConnection)connection;
                ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials vertexAICreds = vertexAILLMConnection.getFullyResolvedCredentials_fsLike(ctx, ConnectionWithGoogleAuthCredentials.SerializableGoogleAuthCredentials.class);
                return new VertexClient(vertexAILLMConnection, vertexAICreds.toGoogleCredential(ctx, vertexAILLMConnection), vertexAILLMConnection.params.project, vertexAILLMConnection.params.region, vertexAILLMConnection.getLLMModel(identifier));
            }
            case "SageMaker-GenericLLM": {
                SageMakerGenericLLMConnection smGenericLLMConnection = (SageMakerGenericLLMConnection)connection;
                smGenericLLMConnection.ensureDecrypted();
                return new SageMakerLLMClient(authCtx, smGenericLLMConnection, smGenericLLMConnection.getLLMModel(identifier));
            }
            case "AzureLLM": {
                AzureLLMConnection azureLLMConnection = (AzureLLMConnection)connection;
                azureLLMConnection.ensureDecrypted();
                return new AzureLLMClient(authCtx, azureLLMConnection, azureLLMConnection.getLLMModel(identifier), projectKey);
            }
            case "NVIDIA-NIM": {
                NvidiaNimConnection nvidiaNimConnection = (NvidiaNimConnection)connection;
                nvidiaNimConnection.ensureDecrypted();
                return new NvidiaNimClient(nvidiaNimConnection, nvidiaNimConnection.getLLMModel(identifier), projectKey, authCtx);
            }
        }
        throw new IllegalArgumentException("Not a remote LLM connection");
    }

    public static LLMClient get(AuthCtx authCtx, String projectKey, LLMStructuredRef identifier) throws Exception {
        return LLMClientFactory.get(authCtx, projectKey, identifier, false);
    }

    public static LLMClient get(AuthCtx authCtx, String projectKey, LLMStructuredRef identifier, boolean devKernel) throws Exception {
        LLMClientAndModelHandle llmClientAndModelHandle = LLMClientFactory.get_NoCostLimiting(authCtx, projectKey, identifier, devKernel);
        if (LLMCostLimitingService.isFeatureEnabled() && ClusterSelector.getContext() == MainLoggingConfigurator.ProcessType.BACKEND && llmClientAndModelHandle.llmClient.requiresCostLimiting()) {
            return new LLMClientCostLimitingWrapper(llmClientAndModelHandle.llmClient, authCtx, projectKey, llmClientAndModelHandle.modelHandle);
        }
        return llmClientAndModelHandle.llmClient;
    }

    private static RetrievableKnowledge getValidRK(AuthCtx authCtx, String projectKey, SavedModel.SavedModelInlineVersion smiv) throws Exception {
        RetrievableKnowledge rk;
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        AnyLoc locRK = AnyLoc.resolveSmart(projectKey, smiv.ragllmSettings.kbRef);
        try (Transaction ignored = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
            rk = (RetrievableKnowledge)((RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class)).getMandatory(locRK);
            LLMClientFactory.checkRKAccess(authCtx, projectKey, rk);
        }
        return rk;
    }

    private static LLMClientAndModelHandle get_NoCostLimiting(AuthCtx authCtx, String projectKey, LLMStructuredRef identifier, boolean devKernel) throws Exception {
        TransactionService ts = (TransactionService)SpringUtils.getBean(TransactionService.class);
        switch (identifier.type) {
            case RETRIEVAL_AUGMENTED: 
            case SAVED_MODEL_AGENT: {
                SavedModel.SavedModelInlineVersion smiv;
                SavedModel sm;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    AnyLoc loc = AnyLoc.resolveSmart(projectKey, identifier.savedModelSmartId);
                    sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
                    String smVersion = identifier.savedModelVersionId != null ? identifier.savedModelVersionId : sm.activeVersion;
                    smiv = sm.getVersion(smVersion).orElseThrow(() -> new IllegalArgumentException("SMV not found"));
                }
                switch (sm.savedModelType) {
                    case PROXY_MODEL: 
                    case LLM_GENERIC: 
                    case DSS_MANAGED: 
                    case MLFLOW_PYFUNC: {
                        throw new Error("should not be here: " + String.valueOf((Object)sm.savedModelType));
                    }
                    case PLUGIN_AGENT: {
                        return new LLMClientAndModelHandle(new PluginAgentLLMClient((DSSAuthCtx)authCtx, projectKey, sm, smiv, devKernel), null);
                    }
                    case PYTHON_AGENT: {
                        return new LLMClientAndModelHandle(new PythonAgentLLMClient((DSSAuthCtx)authCtx, projectKey, sm, smiv, devKernel), null);
                    }
                    case TOOLS_USING_AGENT: {
                        return new LLMClientAndModelHandle(new ToolsUsingAgentLLMClient((DSSAuthCtx)authCtx, projectKey, sm, smiv, devKernel), null);
                    }
                    case RETRIEVAL_AUGMENTED_LLM: {
                        RetrievableKnowledge rk = LLMClientFactory.getValidRK(authCtx, sm.projectKey, smiv);
                        return new LLMClientAndModelHandle(((RAGKernelPool)SpringUtils.getBean(RAGKernelPool.class)).getClient(authCtx, projectKey, identifier, rk, smiv, devKernel), null);
                    }
                }
            }
            case SAVED_MODEL_FINETUNED_AZURE_OPENAI: {
                AzureOpenAIConnection conn;
                SavedModel sm;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    AnyLoc loc = AnyLoc.resolveSmart(projectKey, identifier.savedModelSmartId);
                    sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
                }
                LLMSMMgmtService.LLMSMVersionHeader vh = LLMSMMgmtService.getStatus_NT((SavedModel)sm).versions.stream().filter(v -> identifier.savedModelVersionId.equals(v.versionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("SMV not found"));
                logger.info((Object)("Working on fine-tuned Azure OpenAI model with version " + identifier.savedModelVersionId));
                logger.info((Object)("Azure OpenAI connection: " + ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection));
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection, AzureOpenAIConnection.class);
                    if (!conn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                }
                AzureOpenAIConnection.AzureOpenAIModel originalModel = (AzureOpenAIConnection.AzureOpenAIModel)conn.getLLMModel(LLMStructuredRef.decodeId(((LLMModelSnippetData)vh.snippet).llmSMInfo.originalLLMId)).getModel();
                SavedLLMModelHandle fineTunedModelHandle = new SavedLLMModelHandle(identifier, (LLMModelSnippetData)vh.snippet, originalModel);
                return new LLMClientAndModelHandle(new AzureOpenAIClient(conn, fineTunedModelHandle, authCtx, projectKey), fineTunedModelHandle);
            }
            case SAVED_MODEL_FINETUNED_BEDROCK: {
                BedrockConnection conn;
                SavedModel sm;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    AnyLoc loc = AnyLoc.resolveSmart(projectKey, identifier.savedModelSmartId);
                    sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
                }
                LLMSMMgmtService.LLMSMVersionHeader vh = LLMSMMgmtService.getStatus_NT((SavedModel)sm).versions.stream().filter(v -> identifier.savedModelVersionId.equals(v.versionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("SMV not found"));
                logger.info((Object)("Working on fine-tuned AWS Bedrock model with version " + identifier.savedModelVersionId));
                logger.info((Object)("AWS Bedrock connection: " + ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection));
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection, BedrockConnection.class);
                    if (!conn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                }
                BedrockConnection.BedrockModel originalModel = (BedrockConnection.BedrockModel)conn.getLLMModel(LLMStructuredRef.decodeId(((LLMModelSnippetData)vh.snippet).llmSMInfo.originalLLMId)).getModel();
                SavedLLMModelHandle fineTunedModelHandle = new SavedLLMModelHandle(identifier, (LLMModelSnippetData)vh.snippet, originalModel);
                return new LLMClientAndModelHandle(new BedrockClient(authCtx, conn, fineTunedModelHandle), fineTunedModelHandle);
            }
            case SAVED_MODEL_FINETUNED_OPENAI: {
                OpenAIConnection conn;
                SavedModel sm = null;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    AnyLoc loc = AnyLoc.resolveSmart(projectKey, identifier.savedModelSmartId);
                    sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
                }
                LLMSMMgmtService.LLMSMVersionHeader vh = LLMSMMgmtService.getStatus_NT((SavedModel)sm).versions.stream().filter(v -> identifier.savedModelVersionId.equals(v.versionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("SMV not found"));
                logger.info((Object)("Working on fine-tuned OpenAI model with version " + identifier.savedModelVersionId));
                logger.info((Object)("OpenAI connection: " + ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection));
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    conn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, ((LLMModelSnippetData)vh.snippet).llmSMInfo.connection, OpenAIConnection.class);
                    if (!conn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                }
                ICredentialsService.BasicCredential creds = conn.getFullyResolvedCredentials_fsLike(new ConnectionWithBasicCredential.CredentialResolutionContext(authCtx, projectKey), ICredentialsService.BasicCredential.class);
                OpenAIConnection.OpenAIModel originalModel = (OpenAIConnection.OpenAIModel)conn.getLLMModel(LLMStructuredRef.decodeId(((LLMModelSnippetData)vh.snippet).llmSMInfo.originalLLMId)).getModel();
                SavedLLMModelHandle fineTunedModelHandle = new SavedLLMModelHandle(identifier, (LLMModelSnippetData)vh.snippet, originalModel);
                return new LLMClientAndModelHandle(new OpenAIClient(conn, fineTunedModelHandle, creds.password, projectKey, authCtx), fineTunedModelHandle);
            }
            case SAVED_MODEL_FINETUNED_HUGGINGFACE_TRANSFORMER: {
                SavedModel sm = null;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    AnyLoc loc = AnyLoc.resolveSmart(projectKey, identifier.savedModelSmartId);
                    sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
                }
                LLMSMMgmtService.LLMSMVersionHeader vh = LLMSMMgmtService.getStatus_NT((SavedModel)sm).versions.stream().filter(v -> identifier.savedModelVersionId.equals(v.versionId)).findFirst().orElseThrow(() -> new IllegalArgumentException("SMV not found"));
                HuggingFaceLocalConnection localHfConnection = null;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    localHfConnection = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, identifier.connection, HuggingFaceLocalConnection.class);
                    if (!localHfConnection.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                    localHfConnection.ensureDecrypted();
                }
                HuggingFaceLocalConnection.HFLocalModel originalModel = localHfConnection.getLLMModelFromSMInfo(((LLMModelSnippetData)vh.snippet).llmSMInfo);
                SavedLLMModelHandle fineTunedModelHandle = new SavedLLMModelHandle(identifier, (LLMModelSnippetData)vh.snippet, originalModel);
                return new LLMClientAndModelHandle(((HuggingFaceKernelPool)SpringUtils.getBean(HuggingFaceKernelPool.class)).getClient(authCtx, localHfConnection, projectKey, fineTunedModelHandle), fineTunedModelHandle);
            }
            case HUGGINGFACE_TRANSFORMER_LOCAL: {
                HuggingFaceLocalConnection llmConn = null;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    llmConn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, identifier.connection, HuggingFaceLocalConnection.class);
                    if (!llmConn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                    llmConn.ensureDecrypted();
                }
                LLMClientFactory.checkLLMAvailableInConnection(identifier, llmConn);
                AbstractLLMConnection.ConnectionModelHandle modelHandle = llmConn.getLLMModel(identifier);
                return new LLMClientAndModelHandle(((HuggingFaceKernelPool)SpringUtils.getBean(HuggingFaceKernelPool.class)).getClient(authCtx, llmConn, projectKey, modelHandle), modelHandle);
            }
            case AZURE_OPENAI_DEPLOYMENT: 
            case AZURE_OPENAI_MODEL: 
            case HUGGINGFACE_API: 
            case OPENAI: 
            case MISTRALAI: 
            case COHERE: 
            case ANTHROPIC: 
            case BEDROCK: 
            case MOSAICML: 
            case VERTEX: 
            case DATABRICKS: 
            case STABILITYAI: 
            case NVIDIA_NIM: 
            case SNOWFLAKE_CORTEX: 
            case SAGEMAKER_GENERICLLM: 
            case AZURE_LLM: {
                AbstractLLMConnection llmConn;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    DSSConnection conn = ConnectionsDAO.get().getMandatoryConnection(authCtx, identifier.connection);
                    if (!conn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                    if (!(conn instanceof AbstractLLMConnection)) {
                        throw new IllegalArgumentException(String.format("Connection %s is not a LLM connection", conn.name));
                    }
                    llmConn = (AbstractLLMConnection)conn;
                }
                LLMClientFactory.checkLLMAvailableInConnection(identifier, llmConn);
                return new LLMClientAndModelHandle(LLMClientFactory.getRemoteLLM_NoCheck(authCtx, projectKey, identifier, llmConn), llmConn.getLLMModel(identifier));
            }
            case CUSTOM: {
                CustomLLMConnection customConn;
                try (Transaction t = ts.retrieveOrBeginRead(IsolationLevel.YOLO);){
                    customConn = ConnectionsDAO.get().getMandatoryConnectionAs(authCtx, identifier.connection, CustomLLMConnection.class);
                    if (!customConn.isFreelyUsableBy(authCtx)) {
                        throw new UnauthorizedException("You may not use this connection", "denied");
                    }
                }
                return new LLMClientAndModelHandle(LLMClientFactory.getCustomLLMClient_NoCheck(authCtx, projectKey, identifier, customConn), customConn.getLLMModel(identifier));
            }
            case SAVED_MODEL_FINETUNED_VERTEX: {
                throw new Error("unimplemented");
            }
        }
        throw new Error("unreachable");
    }

    public static AbstractLLMClient getCustomLLMClient_NoCheck(AuthCtx authCtx, String projectKey, LLMStructuredRef identifier, CustomLLMConnection customConn) {
        AbstractLLMConnection.ConnectionModelHandle modelHandle = customConn.getLLMModel(identifier);
        CustomLLMConnection.LLMModel customModel = (CustomLLMConnection.LLMModel)modelHandle.getModel();
        return CustomLLMTypesRegistry.getClient(authCtx, customConn, projectKey, customModel, modelHandle.getEnrichedRef());
    }

    private static void checkRKAccess(AuthCtx authCtx, String contextProjectKey, RetrievableKnowledge rk) throws Exception {
        switch (ClusterSelector.getContext()) {
            case BACKEND: {
                ((ProjectsService)SpringUtils.getBean(ProjectsService.class)).failIfNoReadAccess(authCtx, rk.getRef(), contextProjectKey);
                return;
            }
            case JEK: {
                APITicketService ticketService = (APITicketService)SpringUtils.getBean(APITicketService.class);
                try (APITicketService.TicketUsage tu = ticketService.getAndUseSingleTicket();
                     TicketBasedIntercomAPIClient apiClient = TicketBasedIntercomAPIClient.forLocalHost(tu.getTicket().getSecret());){
                    apiClient.postFormToJSON("/dip/api/tintercom/permissions/check-taggable-object-read-use-privilege", Void.class, new Object[]{"taggableObjectRef", rk.getRef(), "contextProjectKey", contextProjectKey});
                }
                return;
            }
        }
        throw new IllegalArgumentException("Cannot check access of Knowledge Bank on process " + String.valueOf(ClusterSelector.getContext()));
    }

    public static AbstractLLMConnection getFinalConnectionForGovernance(AuthCtx authCtx, String contextProjectKey, LLMStructuredRef llmRef) throws IOException, DKUSecurityException {
        String connectionToUse = llmRef.connection;
        if (llmRef.connection == null && llmRef.type == LLMStructuredRef.LLMType.RETRIEVAL_AUGMENTED) {
            AnyLoc loc = AnyLoc.resolveSmart(contextProjectKey, llmRef.savedModelSmartId);
            SavedModel sm = (SavedModel)((SavedModelsDAO)SpringUtils.getBean(SavedModelsDAO.class)).getMandatory(loc);
            String activeVersion = llmRef.savedModelVersionId == null ? sm.activeVersion : llmRef.savedModelVersionId;
            SavedModel.SavedModelInlineVersion smiv = sm.getVersion(activeVersion).orElseThrow(() -> new IllegalArgumentException("SMV not found"));
            String underlyingLLMId = smiv.ragllmSettings.llmId;
            connectionToUse = LLMStructuredRef.decodeId((String)underlyingLLMId).connection;
            logger.info((Object)("Underlying LLM: " + underlyingLLMId));
            logger.info((Object)("Underlying connection: " + connectionToUse));
        }
        if (connectionToUse != null) {
            return (AbstractLLMConnection)ConnectionsDAO.get().getMandatoryConnection(authCtx, connectionToUse);
        }
        return null;
    }

    private static class LLMClientAndModelHandle {
        public final LLMClient llmClient;
        public final LLMModelHandle<?> modelHandle;

        private LLMClientAndModelHandle(LLMClient llmClient, @Nullable LLMModelHandle<?> modelHandle) {
            this.llmClient = llmClient;
            this.modelHandle = modelHandle;
        }
    }
}

