/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.llm.online.utils;

import com.dataiku.dip.llm.online.utils.BlockingQueryProcessor;
import com.dataiku.dip.llm.online.utils.QueryProcessor;
import com.dataiku.dip.utils.DKULogger;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class StreamableQueryProcessor<Q, R, FR> {
    private final BlockingQueryProcessor<Q, R> blockingProcessor;
    private final BlockingQueryProcessor.OfferBlockingLinkedBlockingQueue<OutgoingQueueItem> outgoingQueue;
    private final Set<CompletableFuture<R>> pendingProcessingFutures = ConcurrentHashMap.newKeySet();
    private int fetchedResponses = 0;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.llm.online.utils.sqp");

    public StreamableQueryProcessor(QueryProcessor<Q, R> queryProcessor, int incomingQueueSize, int outgoingQueueSize) {
        this.blockingProcessor = new BlockingQueryProcessor<Q, R>(queryProcessor, incomingQueueSize);
        this.outgoingQueue = new BlockingQueryProcessor.OfferBlockingLinkedBlockingQueue(outgoingQueueSize);
    }

    public CompletableFuture<R> submit(Q query, Function<R, FR> finalResponseSupplier) {
        CompletableFuture<R> submittedFuture = this.blockingProcessor.submit(query);
        this.pendingProcessingFutures.add(submittedFuture);
        return submittedFuture.whenComplete((r, e) -> {
            logger.trace((Object)"Offering to outgoing queue");
            if (!this.outgoingQueue.offer(new OutgoingQueueItem(finalResponseSupplier.apply(r)))) {
                logger.warn((Object)"Queue refused our offer after time-out");
            } else {
                logger.trace((Object)"Offered to queue");
            }
            this.pendingProcessingFutures.remove(submittedFuture);
        });
    }

    public Optional<FR> fetchNextResponse() {
        try {
            logger.trace((Object)("Fetching from queue, which currently has size " + this.outgoingQueue.size()));
            OutgoingQueueItem queueItem = (OutgoingQueueItem)this.outgoingQueue.take();
            logger.trace((Object)("Fetched from queue, which now has size " + this.outgoingQueue.size()));
            if (++this.fetchedResponses % 100 == 0) {
                logger.info((Object)("Fetched " + this.fetchedResponses + " responses from response queue"));
            }
            if (queueItem instanceof PoisonousQueueItem) {
                return Optional.empty();
            }
            return Optional.ofNullable(queueItem.response);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Optional.empty();
        }
    }

    public CompletableFuture<Void> done() {
        return CompletableFuture.allOf(this.pendingProcessingFutures.toArray(new CompletableFuture[0])).whenComplete((v, error) -> {
            logger.info((Object)("Pending queries processed. Offering poison. Queue currently has size " + this.outgoingQueue.size()));
            if (!this.outgoingQueue.offer(new PoisonousQueueItem())) {
                logger.warn((Object)"Queue refused our poison offer, hang is likely");
            } else {
                logger.trace((Object)"Offered to queue");
            }
            logger.info((Object)("Poison offered. Queue has size " + this.outgoingQueue.size()));
        });
    }

    class OutgoingQueueItem {
        final FR response;

        OutgoingQueueItem(FR response) {
            this.response = response;
        }
    }

    class PoisonousQueueItem
    extends OutgoingQueueItem {
        PoisonousQueueItem() {
            super(null);
        }
    }
}

