/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.maintainance;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.containers.exec.ContainerExecImagesDeleterService;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.eda.compute.sampling.PurgeUnusedSamples;
import com.dataiku.dip.maintainance.AccessLogRotation;
import com.dataiku.dip.maintainance.BuildGenericUsageSummaryReports;
import com.dataiku.dip.maintainance.CleanDocExtractionTmpDir;
import com.dataiku.dip.maintainance.CleanPerformanceProfiles;
import com.dataiku.dip.maintainance.CleanTemporaryFilesTask;
import com.dataiku.dip.maintainance.CleanTrustedCodeDBTask;
import com.dataiku.dip.maintainance.ComputeMostUsedDatasetTask;
import com.dataiku.dip.maintainance.DkuScheduledTasksService;
import com.dataiku.dip.maintainance.GarbageCollectPersistentNotificationsTask;
import com.dataiku.dip.maintainance.GarbageCollectUserOfflineQueuesTask;
import com.dataiku.dip.maintainance.GitCommitsAnalysisTask;
import com.dataiku.dip.maintainance.GitGCTask;
import com.dataiku.dip.maintainance.ReportOnKubernetesClustersUsage;
import com.dataiku.dip.maintainance.SendDailyDigestsTask;
import com.dataiku.dip.maintainance.SendUserOfflineQueuesTask;
import com.dataiku.dip.maintainance.SendWelcomeEmailsTask;
import com.dataiku.dip.scheduler.runnables.StoppableWithTimeoutService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.Params;
import java.io.IOException;
import org.quartz.SchedulerException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ScheduledTasksService
extends DkuScheduledTasksService {
    public static final String POPULAR_DATASETS_DEFAULT_EXPRESSION = "20 24 4 * * ?";
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private TransactionService transactionService;

    protected String describe(String jobGroup, String jobName) {
        switch (jobName) {
            case "git-gc": {
                return "Performs garbage collection and optimization on the internal Git repository";
            }
            case "git-commits-analysis": {
                return "Gathers statistics from latest Git commits";
            }
            case "clear-upload-box": {
                return "Clears temporary files left by processes such as file uploads or project imports";
            }
            case "build-usage-summary-reports": {
                return "Builds internal usage reports";
            }
            case "send-user-offline-queues": {
                return "Sends users reports about DSS activity while they are offline";
            }
            case "pnotifications-gc": {
                return "Deletes old notifications";
            }
            case "user-offline-queues-gc": {
                return "Deletes old offline queue notifications";
            }
            case "daily-digest": {
                return "Sends user daily digests e-mails";
            }
            case "access-log-rotate": {
                return "Trigger nginx access log daily rotation";
            }
            case "clean-tmp-dir": {
                return "Clean the /tmp directory removing files older than 10 days";
            }
            case "purge-eda-samples": {
                return "Purge samples prepare for statistics unused for too long";
            }
            case "clean-trust-db": {
                return "Delete old entries in the trust database";
            }
            case "compute-most-used-datasets": {
                return "Compute most used datasets";
            }
            case "flush-activity-buffer-to-rrd-files": {
                return "Flush and persist api endpoints activity metrics to rrd files";
            }
            case "clean-old-container-exec-images": {
                return "Delete old container images";
            }
            case "send-welcome-emails": {
                return "Sends welcome emails to users who haven't received them yet.";
            }
            case "clean-docextraction-tmp-dir": {
                return "Cleans the /tmp/docextraction directory, removing files that were not modified for some time";
            }
            case "clean-performance-profiles": {
                return "Remove old performance profiles";
            }
        }
        return "-";
    }

    protected void initScheduledTasks() throws IOException, SchedulerException {
        Params params = ApplicationConfigurator.getParams();
        GeneralSettingsDAO.GeneralSettings gs = null;
        try (Transaction t = this.transactionService.beginRead();){
            gs = this.generalSettingsDAO.getUnsafe();
        }
        this.addCron(StoppableWithTimeoutService.KillExpiredCallables.class, "task-execution", "kill-timedout-tasks", params.getParam("dku.cron.expr.task-execution.kill-timedout-tasks", "0 */30 * * * ?"));
        this.addCron(SendUserOfflineQueuesTask.class, "reporting", "send-user-offline-queues", params.getParam("dku.cron.expr.reporting.send-user-offline-queues", "0 0 */2 * * ?"));
        if (gs.computeResourceUsageReportingSettings.periodicKubernetesUsageReporting) {
            this.addCron(ReportOnKubernetesClustersUsage.class, "reporting", "report-on-kubernetes-clusters-usage", params.getParam("dku.cron.expr.reporting.report-on-kubernetes-clusters-usage", "0 * * * * ?"));
        }
        this.addCron(GitGCTask.class, "maintenance", "git-gc", params.getParam("dku.cron.expr.maintenance.git-gc", "0 5 5 * * ?"));
        this.addCron(GitCommitsAnalysisTask.class, "reporting", "git-commits-analysis", params.getParam("dku.cron.expr.reporting.git-commits-analysis", "1 1 * * * ?"));
        this.addCron(ComputeMostUsedDatasetTask.class, "most-used-datasets", "compute-most-used-datasets", params.getParam("dku.cron.expr.popular-datasets.compute-popular-datasets", POPULAR_DATASETS_DEFAULT_EXPRESSION));
        this.addCron(CleanTemporaryFilesTask.class, "maintenance", "clear-upload-box", params.getParam("dku.cron.expr.maintenance.clear-upload-box", "0 2 5 * * ?"));
        this.addCron(GarbageCollectPersistentNotificationsTask.class, "maintenance", "pnotifications-gc", params.getParam("dku.cron.expr.maintenance.pnotifications-gc", "0 10 5 * * ?"));
        this.addCron(GarbageCollectUserOfflineQueuesTask.class, "maintenance", "user-offline-queues-gc", params.getParam("dku.cron.expr.maintenance.user-offline-queues-gc", "0 20 5 * * ?"));
        this.addCron(AccessLogRotation.class, "maintenance", "access-log-rotate", params.getParam("dku.cron.expr.maintenance.access-log-rotate", "0 30 5 * * ?"));
        this.addCron(PurgeUnusedSamples.class, "maintenance", "purge-eda-samples", params.getParam("dku.cron.expr.maintenance.purge-eda-samples", "0 40 5 * * ?"));
        this.addCron(SendDailyDigestsTask.class, "reporting", "daily-digest", params.getParam("dku.cron.expr.reporting.daily-digest", "0 6 6 * * ?"));
        this.addCron(ContainerExecImagesDeleterService.ImagesDeleter.class, "maintenance", "clean-old-container-exec-images", params.getParam("dku.cron.expr.maintenance.clean-old-container-exec-images", "0 45 6 * * ?"));
        this.addCron(CleanDocExtractionTmpDir.class, "maintenance", "clean-docextraction-tmp-dir", params.getParam("dku.cron.expr.maintenance.clean-docextraction-tmp-dir", "0 00 7 * * ?"));
        this.addCron(CleanPerformanceProfiles.class, "maintenance", "clean-performance-profiles", params.getParam("dku.cron.expr.maintenance.clean-performance-profiles", "0 00 8 * * ?"));
        this.addCron(BuildGenericUsageSummaryReports.class, "reporting", "build-usage-summary-reports", params.getParam("dku.cron.expr.reporting.build-usage-summary-report", "3 3 4 ? * 2"));
        this.addCron(CleanTrustedCodeDBTask.class, "maintenance", "clean-trust-db", params.getParam("dku.cron.expr.reporting.clean-trust-db", "3 3 4 ? * 3"));
        this.addCron(SendWelcomeEmailsTask.class, "maintenance", "send-welcome-emails", params.getParam("dku.cron.expr.maintenance.send-welcome-emails", "0 30 9 * * ?"));
    }
}

