/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.metrics.probes;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetCodes;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.meanings.IBasicMeaningsService;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricComputation;
import com.dataiku.dip.metrics.MetricComputer;
import com.dataiku.dip.metrics.MetricMetadata;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.engines.BasicMetricsEngine;
import com.dataiku.dip.metrics.engines.MetricsEngineRun;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.ProbeConfiguration;
import com.dataiku.dip.metrics.probes.ProbeMetadata;
import com.dataiku.dip.metrics.probes.ProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PartitioningProbeType
extends ProbeType {
    public static final String TYPE = "partitioning";
    private static Map<PartitioningMetrics, MetricMetadata> metadataPerType = Maps.newHashMap();
    private static Logger logger = Logger.getLogger((String)"dku.datasets.metrics.partition");

    @Override
    public List<MetricComputer> getComputers(IBasicMeaningsService basicMeaningsService) {
        ArrayList computers = Lists.newArrayList();
        computers.add(new DatasetPartitionCountComputer());
        computers.add(new DatasetPartitionListComputer());
        computers.add(new ManagedFolderPartitionCountComputer());
        computers.add(new ManagedFolderPartitionListComputer());
        return computers;
    }

    public PartitioningProbeType() {
        metadataPerType.put(PartitioningMetrics.COUNT_PARTITIONS, new MetricMetadata().withName("Partition count").withFullName("Partition count"));
        metadataPerType.put(PartitioningMetrics.PARTITIONS_LIST, new MetricMetadata().withName("Partition list").withFullName("Partition list"));
        this.type = TYPE;
    }

    @Override
    public List<Metric> listBuildableMetrics(Object object, MetricTargetType objectType) {
        ManagedFolder folder;
        Dataset dataset;
        ArrayList metrics = Lists.newArrayList();
        if (objectType == MetricTargetType.DATASET && (dataset = (Dataset)object).getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
            metrics.add(new PartitioningMetric(PartitioningMetrics.COUNT_PARTITIONS));
            metrics.add(new PartitioningMetric(PartitioningMetrics.PARTITIONS_LIST));
        }
        if (objectType == MetricTargetType.MANAGED_FOLDER && (folder = (ManagedFolder)object).getPartitioningSchema() != null && folder.getPartitioningSchema().isPartitioned()) {
            metrics.add(new PartitioningMetric(PartitioningMetrics.COUNT_PARTITIONS));
            metrics.add(new PartitioningMetric(PartitioningMetrics.PARTITIONS_LIST));
        }
        return metrics;
    }

    @Override
    public List<Metric> getMetricsToCompute(Probe probe, Object object, MetricTargetType objectType, boolean forDisplay) {
        ArrayList metrics = Lists.newArrayList();
        metrics.add(new PartitioningMetric(PartitioningMetrics.COUNT_PARTITIONS));
        metrics.add(new PartitioningMetric(PartitioningMetrics.PARTITIONS_LIST));
        return metrics;
    }

    @Override
    public Object listSelectableMetrics(Probe probe, Object object, MetricTargetType objectType) {
        ManagedFolder folder;
        if (objectType == MetricTargetType.DATASET) {
            Dataset dataset = (Dataset)object;
            if (dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
                PartitioningProbeHint hint = new PartitioningProbeHint();
                hint.hasCountPartitions = true;
                hint.hasPartitionsList = true;
                return hint;
            }
        } else if (objectType == MetricTargetType.MANAGED_FOLDER && (folder = (ManagedFolder)object).getPartitioningSchema() != null && folder.getPartitioningSchema().isPartitioned()) {
            PartitioningProbeHint hint = new PartitioningProbeHint();
            hint.hasCountPartitions = true;
            hint.hasPartitionsList = true;
            return hint;
        }
        return null;
    }

    @Override
    public ProbeConfiguration buildFullConfiguration(List<SchemaColumn> column, Probe probe) {
        return null;
    }

    @Override
    public ProbeType trimForSave() {
        return new PartitioningProbeType();
    }

    @Override
    public Class<? extends ProbeConfiguration> getParamsClazz() {
        return PartitioningProbeConfiguration.class;
    }

    @Override
    public ProbeMetadata getMeta() {
        return new ProbeMetadata().withLevel(1).withName("Partitioning statistics");
    }

    @Override
    public boolean isUserSelectedProbe() {
        return false;
    }

    public static class DatasetPartitionCountComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return PartitioningProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof PartitioningMetric && ((PartitioningMetric)metric).getMetricType() == PartitioningMetrics.COUNT_PARTITIONS && objectType == MetricTargetType.DATASET) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                logger.info((Object)("Partition count of single partition " + engine.getPartition().id()));
                return Long.toString(1L);
            }
            logger.info((Object)"Enumerating FS to get partition count");
            return Long.toString(engine.getPartitions().size());
        }
    }

    public static class DatasetPartitionListComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return PartitioningProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (metric instanceof PartitioningMetric && ((PartitioningMetric)metric).getMetricType() == PartitioningMetrics.PARTITIONS_LIST && objectType == MetricTargetType.DATASET) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            ArrayList partitionIds = Lists.newArrayList();
            if (!MetricsComputationService.isFullDataset(engine.getDataset(), engine.getPartition())) {
                logger.info((Object)("Partition list of single partition " + engine.getPartition().id()));
                partitionIds.add(engine.getPartition().id());
            } else {
                logger.info((Object)"Enumerating FS to get partition list");
                for (Partition partition : engine.getPartitions()) {
                    partitionIds.add(partition.id());
                }
            }
            return JSON.json((Object)partitionIds);
        }
    }

    public static class ManagedFolderPartitionCountComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return PartitioningProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.MANAGED_FOLDER && metric instanceof PartitioningMetric && ((PartitioningMetric)metric).getMetricType() == PartitioningMetrics.COUNT_PARTITIONS) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            if (!MetricsComputationService.isFullDataset(engine.getFolder(), engine.getPartition())) {
                logger.info((Object)("Partition count of single partition " + engine.getPartition().id()));
                return Long.toString(1L);
            }
            logger.info((Object)"Enumerating FS to get partition count");
            return Long.toString(engine.getPartitions().size());
        }
    }

    public static class ManagedFolderPartitionListComputer
    extends BasicMetricsEngine.BasicMetricsEngineComputer {
        @Override
        public String getProbeType() {
            return PartitioningProbeType.TYPE;
        }

        @Override
        public MetricsEngineRun handles(AuthCtx authCtx, Probe probe, Metric metric, Object object, MetricTargetType objectType, Partition partition) {
            if (objectType == MetricTargetType.MANAGED_FOLDER && metric instanceof PartitioningMetric && ((PartitioningMetric)metric).getMetricType() == PartitioningMetrics.PARTITIONS_LIST) {
                return new BasicMetricsEngine.BasicMetricsEngineRun().with(new MetricComputation(probe, this, metric, 1.0));
            }
            return null;
        }

        @Override
        public String getAggregate(BasicMetricsEngine.BasicMetricsEngineCallbacks engine, MetricComputation computation) throws Exception {
            ArrayList partitionIds = Lists.newArrayList();
            if (!MetricsComputationService.isFullDataset(engine.getFolder(), engine.getPartition())) {
                logger.info((Object)("Partition list of single partition " + engine.getPartition().id()));
                partitionIds.add(engine.getPartition().id());
            } else {
                logger.info((Object)"Enumerating FS to get partition list");
                for (Partition partition : engine.getPartitions()) {
                    partitionIds.add(partition.id());
                }
            }
            return JSON.json((Object)partitionIds);
        }
    }

    public static enum PartitioningMetrics {
        COUNT_PARTITIONS,
        PARTITIONS_LIST;

    }

    public static class PartitioningMetric
    extends Metric {
        public PartitioningMetrics metricType;

        public PartitioningMetric(PartitioningMetrics metricType) {
            super(PartitioningProbeType.TYPE, PartitioningMetric.getDataTypeFromMetricType(metricType));
            this.metricType = metricType;
            this.id = Metric.serializeMetric(this);
        }

        private static Type getDataTypeFromMetricType(PartitioningMetrics metricType) {
            return metricType == PartitioningMetrics.COUNT_PARTITIONS ? Type.BIGINT : Type.ARRAY;
        }

        public PartitioningMetrics getMetricType() {
            return this.metricType;
        }

        @Override
        public String getColumn() {
            return null;
        }

        @Override
        public String getColumnInvariantId(String placeholder) {
            return this.getId();
        }

        @Override
        public MetricMetadata getMeta() {
            return metadataPerType.get((Object)this.metricType);
        }

        @Override
        public Probe getMatchingProbe(List<Probe> probes) {
            return new Probe(this.getType()).withConfiguration(new PartitioningProbeConfiguration()).withMeta(ProbeType.getProbeType(PartitioningProbeType.TYPE).getMeta());
        }
    }

    public static class PartitioningProbeHint {
        boolean hasCountPartitions;
        boolean hasPartitionsList;
    }

    public static class PartitioningProbeConfiguration
    implements ProbeConfiguration {
    }

    public static class PartitioningMetricSerializer
    implements Metric.MetricIdSerializer {
        @Override
        public String serializeMetric(Metric metric) {
            if (!(metric instanceof PartitioningMetric)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metric.getClass().getSimpleName());
            }
            PartitioningMetric partitioningMetric = (PartitioningMetric)metric;
            return Metric.buildMetricIdFromParts(PartitioningProbeType.TYPE, partitioningMetric.getMetricType().name());
        }

        @Override
        public Metric deserializeMetric(String metricId) {
            List<String> parts = Metric.buildPartsFromMetricId(metricId);
            if (parts.size() != 2 || !parts.get(0).equals(PartitioningProbeType.TYPE)) {
                throw new CodedRuntimeException((InfoMessage.MessageCode)DatasetCodes.ERR_DATASET_INVALID_METRIC_IDENTIFIER, "Probe type " + this.getClass().getSimpleName() + " does not handle " + metricId);
            }
            return new PartitioningMetric(PartitioningMetrics.valueOf(parts.get(1)));
        }
    }
}

