/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.nodeclients;

import com.dataiku.common.rpc.APIKeyAuthAPIClient;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.nodeclients.IUnifiedMonitoringClient;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.unifiedmonitoring.ModelStatus;
import com.dataiku.dip.unifiedmonitoring.payloads.UnifiedMonitoringProxySMVWithModelStatus;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DesignNodeClient
extends APIKeyAuthAPIClient
implements IUnifiedMonitoringClient {
    private static final String PUBLIC_BASE_URL = "public/api/";
    private static final String PROJECTS_BASE_URL = "public/api/projects/";

    public DesignNodeClient(GeneralSettingsDAO.RemoteDesignNodeCreds remoteDesignNodeCreds, ProxySettings proxySettings, int connectTimeout, int socketTimeout) {
        super(remoteDesignNodeCreds.url, remoteDesignNodeCreds.apiKey, remoteDesignNodeCreds.trustAllSSLCertificates, proxySettings, connectTimeout, socketTimeout);
    }

    protected String getPossibleBadInfraHint() {
        return ", please check URL of remote design node (" + this.baseURI + ") or server version";
    }

    @Override
    public List<UnifiedMonitoringProxySMVWithModelStatus> listProxyModelVersionWithModelStatus() throws IOException {
        String listProxyModelVersionWithModelStatusPath = "public/api//unified-monitoring-design/proxy-model-versions-with-model-status";
        return (List)this.get(listProxyModelVersionWithModelStatusPath, (TypeToken)new TypeToken<List<UnifiedMonitoringProxySMVWithModelStatus>>(){});
    }

    public String getNodeId() throws IOException {
        String getNodeIdPath = "public/api/admin/get-node-id";
        return this.getFormToString(getNodeIdPath, new Object[0]);
    }

    @Override
    public ModelStatus getModelStatus(@Nonnull String projectKey, @Nonnull String fullModelId, @Nullable List<String> mesToFilterOn) throws IOException {
        String getModelStatusIdPath = PUBLIC_BASE_URL + String.format("/projects/%s/unified-monitoring-design/model-status/%s", projectKey, fullModelId);
        return (ModelStatus)this.getForm(getModelStatusIdPath, ModelStatus.class, new Object[]{"mesToFilterOn", mesToFilterOn});
    }

    @Override
    public ProjectsService.UIProject getProjectSummary(String projectKey) throws IOException {
        return (ProjectsService.UIProject)this.get(PROJECTS_BASE_URL + projectKey, ProjectsService.UIProject.class);
    }
}

