/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.common.datebinner;

import com.dataiku.dip.pivot.backend.common.datebinner.AbstractDateBinner;
import com.dataiku.dip.pivot.backend.model.DateAxisElt;
import com.dataiku.dip.sql.DatePart;
import com.dataiku.dip.sql.DateRounding;
import com.dataiku.dip.sql.SQLDialect;
import javax.annotation.Nullable;

abstract class AbstractTimelineBinner
extends AbstractDateBinner {
    AbstractTimelineBinner() {
    }

    @Override
    public long getBinEndTimestamp(long binId) {
        return this.getBinStartTimestamp(binId + 1L) - 1L;
    }

    @Override
    public int getFixedNbBins() {
        return -1;
    }

    @Override
    public DateAxisElt buildDateAxisElt(@Nullable Long binId, @Nullable Long timestamp, int index) {
        DateAxisElt result = super.buildDateAxisElt(binId, timestamp, index);
        result.min = result.tsValue;
        long computedBinId = (long)result.sortValue;
        result.max = this.getBinEndTimestamp(computedBinId);
        return result;
    }

    @Override
    public long getBinIdFromSqlValue(long sqlValue) {
        return (int)this.getBinId(sqlValue * 1000L);
    }

    @Override
    public long getSqlValueFromBinId(long binId) {
        return binId;
    }

    abstract DateRounding dateRounding();

    @Override
    DatePart datePart() {
        return DatePart.SECOND_FROM_EPOCH;
    }

    @Override
    String datePartExpression(String input, SQLDialect dialect) {
        return dialect.dateTrunc(input, this.dateRounding());
    }

    @Override
    public boolean requireMaterializationForSqlEngine(boolean naturallyOrdered) {
        return true;
    }

    @Override
    public boolean requireJoinForSqlEngine() {
        throw new IllegalStateException("This code is currently never supposed to be called.");
    }
}

