/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.density;

import com.dataiku.dip.pivot.backend.density.MultiplicativeGaussian2DKernel;

public class NaiveStreaming2DKDE {
    private double[] stepsMatrix;
    private double xMin;
    private double yMin;
    private int xSteps;
    private int ySteps;
    private double xStepLen;
    private double yStepLen;
    private double[] lambda;
    private int nbValues;
    private MultiplicativeGaussian2DKernel kernel = new MultiplicativeGaussian2DKernel();
    private boolean computed;

    public NaiveStreaming2DKDE(double[] lambda, double xMin, double xMax, double yMin, double yMax, int xSteps, int ySteps) {
        assert (lambda.length == 2);
        this.lambda = lambda;
        this.xMin = xMin;
        this.yMin = yMin;
        this.xSteps = xSteps;
        this.ySteps = ySteps;
        this.xStepLen = (xMax - xMin) / (double)xSteps;
        this.yStepLen = (yMax - yMin) / (double)ySteps;
        this.stepsMatrix = new double[xSteps * ySteps];
    }

    public void add(double x, double y) {
        ++this.nbValues;
        for (int xc = 0; xc < this.xSteps; ++xc) {
            for (int yc = 0; yc < this.ySteps; ++yc) {
                double xV = this.xMin + (double)xc * this.xStepLen;
                double yV = this.yMin + (double)yc * this.yStepLen;
                double xDist = x - xV;
                double yDist = y - yV;
                double kernelV = this.kernel.compute(xDist / this.lambda[0], yDist / this.lambda[1]);
                int n = xc + yc * this.xSteps;
                this.stepsMatrix[n] = this.stepsMatrix[n] + kernelV;
            }
        }
    }

    public double[] getData() {
        if (!this.computed) {
            double denom = 1.0 / ((double)this.nbValues * this.lambda[0] * this.lambda[1]);
            int i = 0;
            while (i < this.stepsMatrix.length) {
                int n = i++;
                this.stepsMatrix[n] = this.stepsMatrix[n] * denom;
            }
            this.computed = true;
        }
        return this.stepsMatrix;
    }
}

