/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.aggregators;

import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.DataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataList;
import com.dataiku.dip.pivot.backend.dss.aggregators.AbstractAggregator;
import com.dataiku.dip.pivot.backend.model.Aggregation;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.PivotTableTensorRequest;
import com.google.refine.expr.functions.dataiku.DKUFormulaUtils;
import java.io.IOException;

public abstract class GenericAggregator<T>
extends AbstractAggregator<T> {
    protected GenericAggregator(Aggregation req, DataTensor<T> tensor) {
        super(req, tensor);
    }

    @Override
    public void handleBlock(ColumnBlock block, int start, int rows, int[] coords, int[] bins, boolean[] filters, boolean fillAxes) throws IOException {
        for (int row = start; row < rows; ++row) {
            int[] destBin;
            if (filters != null && !filters[row] || (destBin = this.extractDestBin(row, coords, bins)) == null) continue;
            if (block.doubles == null) {
                this.handle(block.getAsStringSlow(row), destBin, fillAxes);
                continue;
            }
            if (Type.DATE.equals((Object)block.realType)) {
                this.handle(DKUFormulaUtils.asDate(block.doubles[row], true, null), destBin, fillAxes);
                continue;
            }
            this.handle(block.doubles[row], destBin, fillAxes);
        }
    }

    @Override
    public boolean mergeTensorAndAxes(PivotTableTensorRequest request, int[] origCoordinates, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
        Object value = this.getValue(origCoordinates, true);
        for (int i = 0; i < axes.length; ++i) {
            if (targetCoordinates[i] != axes[i].nbNotCutoff) continue;
            if (!request.axes[i].sortPrune.generateOthersCategory) {
                return false;
            }
            this.getMergeDT().setAxis(i, targetCoordinates[i], this.mergeValues(this.getMergeDT().getAxis(i, targetCoordinates[i]), value));
        }
        this.getMergeDT().set(targetCoordinates, this.mergeValues(this.getMergeDTValue(targetCoordinates, true), value), true);
        if (this.getOutDT().hasNullValues) {
            this.getMergeDT().incrementNonNullCount(targetCoordinates, this.getOutDT().getNonNullCount(origCoordinates));
        }
        return true;
    }

    @Override
    public void mapFillMergeDT(LongDataList countList) {
        for (int i = 0; i < this.getOutDT().tensorSize; ++i) {
            Object value = this.getValue(i, countList);
            this.getMergeDT().set(i, value, true);
        }
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, LongDataList countList) {
        ret.elts.sort((o1, o2) -> {
            Object v1 = this.getValue(o1.binIndex, countList);
            Object v2 = this.getValue(o2.binIndex, countList);
            return this.compare(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, this.getOutDT().nonNullCounts);
        });
    }

    @Override
    public void sortAxis(AxisHandler.Axis ret, int asc, int axisIdx) {
        long[] nnc = this.getOutDT().axesNonNullCounts[axisIdx];
        ret.elts.sort((o1, o2) -> {
            Object v1 = this.getValue(this.getOutDT().getAxis(axisIdx, o1.binIndex), nnc[o1.binIndex]);
            Object v2 = this.getValue(this.getOutDT().getAxis(axisIdx, o2.binIndex), nnc[o2.binIndex]);
            return this.compare(v1, v2, (AxisElt)o1, (AxisElt)o2, asc, nnc);
        });
    }

    private int compare(T v1, T v2, AxisElt o1, AxisElt o2, int asc, long[] nnc) {
        double nnc1 = nnc[o1.binIndex];
        double nnc2 = nnc[o2.binIndex];
        if (this.getOutDT().hasNullValues && (nnc1 == 0.0 || nnc2 == 0.0)) {
            if (nnc1 == nnc2) {
                return 0;
            }
            if (nnc1 == 0.0) {
                return 1;
            }
            return -1;
        }
        return asc * this.compareValues(v1, v2);
    }
}

