/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.boxplots;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.common.automaticbin.BoxplotsAutomaticRequestHandler;
import com.dataiku.dip.pivot.backend.common.highcardinality.BinsAndTensorsSafetyChecks;
import com.dataiku.dip.pivot.backend.dss.AxisHandler;
import com.dataiku.dip.pivot.backend.dss.GenericDataTensor;
import com.dataiku.dip.pivot.backend.dss.LongDataTensor;
import com.dataiku.dip.pivot.backend.dss.PivotTableAggrBuilder;
import com.dataiku.dip.pivot.backend.dss.TensorPivotBuilder;
import com.dataiku.dip.pivot.backend.dss.aggregators.FlushableAggregator;
import com.dataiku.dip.pivot.backend.model.AxisDef;
import com.dataiku.dip.pivot.backend.model.AxisElt;
import com.dataiku.dip.pivot.backend.model.AxisSortPrune;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsRequest;
import com.dataiku.dip.pivot.backend.model.boxplots.PTBoxplotsResponse;
import com.dataiku.dip.shaker.filter.FilteringExecutor;
import com.dataiku.dip.utils.DKULogger;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.apache.commons.math3.stat.descriptive.rank.Percentile;

public class BoxPlotsBuilder
extends PivotTableAggrBuilder {
    private static final int MAX_RECORDS_EXACT_HANDLING = 10000;
    private final PTBoxplotsRequest request;
    BoxplotTmpData global;
    AxisHandler[] axisHandler;
    private long beforeFilterRecords = 0L;
    private long afterFilterRecords = 0L;
    BoxplotAggregatorBase<BoxplotTmpData, PTBoxplotsResponse.Boxplot> aggregator;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.shaker.pivot");

    public BoxPlotsBuilder(PTBoxplotsRequest request) {
        this.request = request;
        this.filtered = request.isFiltered();
    }

    public PTBoxplotsResponse buildFromLino(LinoReader linoReader) throws Exception {
        this.buildLinoFilters(this.request, linoReader);
        boolean useExact = linoReader.nbRecords() < 10000L;
        int maxDrawnBoxPlots = DKUApp.getParams().getIntParam("dku.charts.boxplots.maxDrawnBoxplots", Integer.valueOf(2000));
        LongDataTensor countsTensor = null;
        this.global = new BoxplotTmpData(useExact);
        if (this.request.axes != null && this.request.axes.length > 0) {
            logger.info((Object)"Have an axis handler, handle it");
            new BoxplotsAutomaticRequestHandler(this.request, linoReader, maxDrawnBoxPlots).replaceAutomaticAggregationLevels();
            BinsAndTensorsSafetyChecks.failIfTooManyBinsBasedOnExplicitConfiguration(null, this.request.axes);
            this.axisHandler = new AxisHandler[this.request.axes.length];
            for (int i = 0; i < this.request.axes.length; ++i) {
                this.axisHandler[i] = BoxPlotsBuilder.buildLinoAxisHandler(linoReader, this.request.axes[i]);
            }
            for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
                int i;
                boolean[] filters = null;
                ColumnBlock[] axisBlocks = new ColumnBlock[this.axisHandler.length];
                for (i = 0; i < this.axisHandler.length; ++i) {
                    axisBlocks[i] = linoReader.readColumnBlock(this.request.axes[i].column, blockIdx);
                }
                if (this.filtered) {
                    filters = new boolean[axisBlocks[0].nbRecords()];
                    this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
                }
                for (i = 0; i < this.axisHandler.length; ++i) {
                    this.axisHandler[i].observe(axisBlocks[i], filters);
                }
            }
            int[] nbBins = new int[this.axisHandler.length];
            for (int i = 0; i < nbBins.length; ++i) {
                nbBins[i] = this.axisHandler[i].getNbBins();
                BinsAndTensorsSafetyChecks.failIfTooManyBinsOnSingleAxis(null, nbBins[i]);
            }
            countsTensor = new LongDataTensor(nbBins);
            this.buildAggregator(useExact, nbBins);
        }
        logger.info((Object)"Get the real thing");
        for (int blockIdx = 0; blockIdx < linoReader.nblocks(); ++blockIdx) {
            int i;
            int[][] bins = null;
            ColumnBlock columnDataBlock = linoReader.readColumnBlock(this.request.column.column, blockIdx);
            boolean[] filters = null;
            if (this.filtered) {
                filters = new boolean[columnDataBlock.nbRecords()];
                this.filterLinoBlock(this.request, linoReader, blockIdx, filters);
            }
            if (this.axisHandler != null) {
                bins = new int[this.axisHandler.length][];
                ColumnBlock[] axisBlock = new ColumnBlock[this.axisHandler.length];
                for (i = 0; i < bins.length; ++i) {
                    axisBlock[i] = linoReader.readColumnBlock(this.request.axes[i].column, blockIdx);
                    bins[i] = new int[axisBlock[i].nbRecords()];
                    this.axisHandler[i].getBins(axisBlock[i], bins[i], filters);
                }
            }
            this.updateLinoFilterFacets(this.request, linoReader, blockIdx);
            this.beforeFilterRecords += (long)columnDataBlock.nbRecords();
            this.afterFilterRecords = filters == null ? (this.afterFilterRecords += (long)columnDataBlock.nbRecords()) : (this.afterFilterRecords += (long)FilteringExecutor.countTrue(filters));
            for (i = 0; i < columnDataBlock.nbRecords(); ++i) {
                if (filters != null && !filters[i]) continue;
                double v = columnDataBlock.doubles[i];
                if (this.axisHandler != null) {
                    assert (bins != null);
                    int[] coords = new int[this.axisHandler.length];
                    boolean hasUnsetBin = false;
                    for (int x = 0; x < this.axisHandler.length; ++x) {
                        coords[x] = bins[x][i];
                        if (coords[x] != -1) continue;
                        hasUnsetBin = true;
                    }
                    if (!hasUnsetBin) {
                        for (int cIdx = 0; cIdx < coords.length; ++cIdx) {
                            long[] lArray = countsTensor.axes[cIdx];
                            int n = coords[cIdx];
                            lArray[n] = lArray[n] + 1L;
                        }
                        countsTensor.increment(coords);
                        this.aggregator.handle(coords, v);
                    }
                }
                this.global.aggr(v);
            }
        }
        PTBoxplotsResponse resp = new PTBoxplotsResponse();
        resp.global = new PTBoxplotsResponse.Boxplot();
        this.global.fill(resp.global);
        if (this.axisHandler != null) {
            this.aggregator.end();
            final AxisHandler.Axis[] axes = new AxisHandler.Axis[this.axisHandler.length];
            for (int i = 0; i < axes.length; ++i) {
                axes[i] = this.sortAndPruneAxis(this.request.axes[i], this.axisHandler[i], this.request.axes[i].sortPrune, i, countsTensor);
            }
            this.buildEmptyResponse(resp, axes);
            this.copyCountData(countsTensor, resp.counts, axes);
            final GenericDataTensor destTensor = (GenericDataTensor)new GenericDataTensor.Builder<BoxplotTmpData>().clazz(BoxplotTmpData.class).axisLengths(resp.counts.axisLengths).build();
            TensorPivotBuilder.forAllCells(axes, new TensorPivotBuilder.CoordinateConsumer(){

                @Override
                public void consume(int[] origCoordinates, int[] targetCoordinates) throws IOException {
                    BoxPlotsBuilder.this.aggregator.merge(BoxPlotsBuilder.this.request, origCoordinates, destTensor, targetCoordinates, axes);
                }
            }, true);
            resp.aggregations.add(this.aggregator.mergeEnd(destTensor, resp.counts));
            for (int i = 0; i < this.axisHandler.length; ++i) {
                if (!this.request.axes[i].sortPrune.generateOthersCategory || axes[i].nbNotCutoff == axes[i].elts.size() || resp.counts.axes[i][resp.axisLabels[i].size()] == 0L) continue;
                resp.axisLabels[i].add(this.createOtherBin());
            }
        }
        resp.axisDefs = this.request.axes != null ? Arrays.asList(this.request.axes) : Collections.emptyList();
        this.computeFilterFacets(this.request, resp);
        resp.setRecordCounts(this.beforeFilterRecords, this.afterFilterRecords);
        return resp;
    }

    public void cleanup() {
        if (this.aggregator != null) {
            try {
                this.aggregator.close();
            }
            catch (Exception e) {
                logger.info((Object)"Error occurred during cleanup", (Throwable)e);
            }
        }
    }

    private void copyCountData(final LongDataTensor origTensor, final LongDataTensor destTensor, final AxisHandler.Axis[] axes) throws IOException {
        block0: for (int i = 0; i < axes.length; ++i) {
            int targetBin = 0;
            for (int x = 0; x < axes[i].elts.size(); ++x) {
                if (axes[i].elts.get((int)x).cutoffed) continue;
                int origBin = axes[i].elts.get((int)x).binIndex;
                destTensor.axes[i][targetBin] = origTensor.axes[i][origBin];
                if (++targetBin >= axes[i].nbNotCutoff) continue block0;
            }
        }
        final LongDataTensor.LongMerger countMerger = Long::sum;
        TensorPivotBuilder.forAllCells(axes, new TensorPivotBuilder.CoordinateConsumer(){

            @Override
            public void consume(int[] origCoordinates, int[] targetCoordinates) {
                long newValue = origTensor.get(origCoordinates);
                for (int i = 0; i < axes.length; ++i) {
                    if (targetCoordinates[i] != axes[i].nbNotCutoff) continue;
                    if (!BoxPlotsBuilder.this.request.axes[i].sortPrune.generateOthersCategory) {
                        return;
                    }
                    destTensor.axes[i][targetCoordinates[i]] = countMerger.merge(destTensor.axes[i][targetCoordinates[i]], newValue);
                }
                destTensor.merge(targetCoordinates, countMerger, newValue);
            }
        }, true);
    }

    private void buildEmptyResponse(PTBoxplotsResponse response, AxisHandler.Axis[] axes) {
        response.engine = PivotTableResponse.PivotEngine.LINO;
        response.axisLabels = new List[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            response.axisLabels[i] = new ArrayList<AxisElt>();
            if (this.request.axes[i].sortPrune.maxValues > 0L) {
                axes[i].nbNotCutoff = (int)Math.min(this.request.axes[i].sortPrune.maxValues, (long)axes[i].nbNotCutoff);
                int notCutoff = 0;
                for (int x = 0; x < axes[i].elts.size(); ++x) {
                    if (axes[i].elts.get((int)x).cutoffed || ++notCutoff <= (int)this.request.axes[i].sortPrune.maxValues) continue;
                    axes[i].elts.get((int)x).cutoffed = true;
                }
            }
            for (int x = 0; x < axes[i].elts.size(); ++x) {
                if (axes[i].elts.get((int)x).cutoffed) continue;
                response.axisLabels[i].add(axes[i].elts.get(x));
            }
        }
        int[] axisLengths = new int[axes.length];
        for (int i = 0; i < axisLengths.length; ++i) {
            axisLengths[i] = this.request.axes[i].sortPrune.generateOthersCategory ? axes[i].nbNotCutoff + 1 : axes[i].nbNotCutoff;
        }
        response.counts = new LongDataTensor(axisLengths);
    }

    private AxisHandler.Axis sortAndPruneAxis(AxisDef axisDef, AxisHandler axisHandler, AxisSortPrune sortPrune, int axisIdx, LongDataTensor countsTensor) {
        int i;
        AxisHandler.Axis ret = new AxisHandler.Axis();
        ret.elts = new ArrayList<AxisElt>();
        ArrayList<? extends AxisElt> axisElts = new ArrayList<AxisElt>();
        int idx = 0;
        for (AxisElt elt : axisHandler.getAxisElts()) {
            elt.binIndex = idx++;
            axisElts.add(elt);
        }
        ret.elts = axisElts;
        if (sortPrune == null) {
            ret.nbNotCutoff = ret.elts.size();
            return ret;
        }
        logger.info((Object)("Do SortPrune on axis " + axisIdx + " have " + ret.elts.size() + " elts"));
        if (sortPrune.sortType != null) {
            switch (sortPrune.sortType) {
                case NATURAL: {
                    this.sortAxisOnNatural(axisDef, ret, axisHandler);
                    break;
                }
                case COUNT: {
                    this.sortOnCounts(axisDef, ret, axisIdx, countsTensor);
                    break;
                }
                default: {
                    throw new NotImplementedException();
                }
            }
        }
        for (i = 0; i < ret.elts.size(); ++i) {
            long count = countsTensor.axes[axisIdx][ret.elts.get((int)i).binIndex];
            if (count != 0L) continue;
            ret.elts.get((int)i).cutoffed = true;
        }
        for (i = 0; i < ret.elts.size(); ++i) {
            if (ret.elts.get((int)i).cutoffed) continue;
            ++ret.nbNotCutoff;
        }
        return ret;
    }

    private void buildAggregator(boolean useExact, int[] nbBins) {
        this.aggregator = useExact ? new ExactBoxplotAggregator(nbBins) : new EstimatorBoxplotAggregator(nbBins);
    }

    private void sortOnCounts(AxisDef def, AxisHandler.Axis ret, int axisIdx, LongDataTensor countTensor) {
        int asc = def.sortPrune.sortAscending ? 1 : -1;
        ret.elts.sort((o1, o2) -> {
            long c1 = countTensor.axes[axisIdx][o1.binIndex];
            long c2 = countTensor.axes[axisIdx][o2.binIndex];
            return asc * Long.compare(c1, c2);
        });
    }

    class BoxplotTmpData {
        int nbNAN;
        int nbPosInf;
        int nbNegInf;
        int nbValid;
        double max = Double.MIN_VALUE;
        double min = Double.MAX_VALUE;
        double sum;
        PSquarePercentile appMedian;
        PSquarePercentile appP25;
        PSquarePercentile appP75;
        PSquarePercentile appLowWhisker;
        PSquarePercentile appHighWhisker;
        double[] validStore;
        StandardDeviation stddev;

        BoxplotTmpData(boolean useExact) {
            if (!useExact) {
                this.appMedian = new PSquarePercentile(50.0);
                this.appP25 = new PSquarePercentile(25.0);
                this.appP75 = new PSquarePercentile(75.0);
                this.appLowWhisker = new PSquarePercentile((double)(100 - BoxPlotsBuilder.this.request.whiskersPercentile));
                this.appHighWhisker = new PSquarePercentile((double)BoxPlotsBuilder.this.request.whiskersPercentile);
            } else {
                this.validStore = new double[4];
            }
            this.stddev = new StandardDeviation();
        }

        void aggr(double d) {
            if (Double.isNaN(d)) {
                ++this.nbNAN;
            } else {
                this.max = Math.max(this.max, d);
                this.min = Math.min(this.min, d);
                this.sum += d;
                this.stddev.increment(d);
                if (this.validStore == null) {
                    this.appMedian.increment(d);
                    this.appP25.increment(d);
                    this.appP75.increment(d);
                    this.appLowWhisker.increment(d);
                    this.appHighWhisker.increment(d);
                } else {
                    if (this.nbValid >= this.validStore.length) {
                        this.validStore = Arrays.copyOf(this.validStore, 2 * this.validStore.length + 1);
                    }
                    this.validStore[this.nbValid] = d;
                }
                ++this.nbValid;
            }
        }

        void fill(PTBoxplotsResponse.Boxplot out) {
            out.min = this.min;
            out.max = this.max;
            out.mean = this.sum / (double)this.nbValid;
            out.nbVAlid = this.nbValid;
            out.nbNAN = this.nbNAN;
            out.stddev = this.stddev.getResult();
            if (this.validStore == null) {
                out.median = this.appMedian.getResult();
                out.pc25 = this.appP25.getResult();
                out.pc75 = this.appP75.getResult();
                out.lowWhisker = this.appLowWhisker.getResult();
                out.highWhisker = this.appHighWhisker.getResult();
            } else {
                Percentile p = new Percentile();
                p.setData(Arrays.copyOfRange(this.validStore, 0, this.nbValid));
                out.median = p.evaluate(50.0);
                out.pc25 = p.evaluate(25.0);
                out.pc75 = p.evaluate(75.0);
                out.lowWhisker = p.evaluate((double)(100 - BoxPlotsBuilder.this.request.whiskersPercentile));
                out.highWhisker = p.evaluate((double)BoxPlotsBuilder.this.request.whiskersPercentile);
            }
        }
    }

    public static interface BoxplotAggregatorBase<T, I> {
        public void handle(int[] var1, double var2) throws IOException;

        public void end() throws IOException;

        public boolean merge(PTBoxplotsRequest var1, int[] var2, GenericDataTensor<T> var3, int[] var4, AxisHandler.Axis[] var5) throws IOException;

        public GenericDataTensor<I> mergeEnd(GenericDataTensor<T> var1, LongDataTensor var2);

        public void close() throws Exception;
    }

    public class ExactBoxplotAggregator
    implements BoxplotAggregatorBase<BoxplotTmpData, PTBoxplotsResponse.Boxplot> {
        private final GenericDataTensor<BoxplotTmpData> boxplotTmpDataGenericDataTensor;

        public ExactBoxplotAggregator(int[] axisLengths) {
            this.boxplotTmpDataGenericDataTensor = (GenericDataTensor)new GenericDataTensor.Builder<BoxplotTmpData>().clazz(BoxplotTmpData.class).axisLengths(axisLengths).build();
        }

        @Override
        public void handle(int[] coords, double value) {
            BoxplotTmpData boxplotTmpData = this.boxplotTmpDataGenericDataTensor.getOrDefault(coords, new BoxplotTmpData(true));
            boxplotTmpData.aggr(value);
        }

        @Override
        public boolean merge(PTBoxplotsRequest request, int[] origCoordinates, GenericDataTensor<BoxplotTmpData> destTensor, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
            BoxplotTmpData oldValue = (BoxplotTmpData)this.boxplotTmpDataGenericDataTensor.get(origCoordinates);
            for (int i = 0; i < axes.length; ++i) {
                if (targetCoordinates[i] != axes[i].nbNotCutoff || request.axes[i].sortPrune.generateOthersCategory) continue;
                return false;
            }
            if (oldValue != null) {
                BoxplotTmpData newValue = destTensor.getOrDefault(targetCoordinates, new BoxplotTmpData(true));
                for (int i = 0; i < oldValue.nbValid; ++i) {
                    newValue.aggr(oldValue.validStore[i]);
                }
            }
            return true;
        }

        @Override
        public GenericDataTensor<PTBoxplotsResponse.Boxplot> mergeEnd(GenericDataTensor<BoxplotTmpData> destTensor, LongDataTensor counts) {
            GenericDataTensor dataTensor = (GenericDataTensor)new GenericDataTensor.Builder<PTBoxplotsResponse.Boxplot>().clazz(PTBoxplotsResponse.Boxplot.class).axisLengths(destTensor.axisLengths).build();
            for (int i = 0; i < destTensor.getTensor().length; ++i) {
                BoxplotTmpData boxplotTmpData = (BoxplotTmpData)destTensor.get(i);
                if (boxplotTmpData == null) continue;
                dataTensor.set(i, new PTBoxplotsResponse.Boxplot(), true);
                boxplotTmpData.fill((PTBoxplotsResponse.Boxplot)dataTensor.get(i));
            }
            return dataTensor;
        }

        @Override
        public void close() {
        }

        @Override
        public void end() throws IOException {
        }
    }

    public class EstimatorBoxplotAggregator
    extends FlushableAggregator
    implements BoxplotAggregatorBase<BoxplotTmpData, PTBoxplotsResponse.Boxplot>,
    FlushableAggregator.Visitor {
        private final GenericDataTensor<BoxplotTmpData> boxplotTmpDataGenericDataTensor;
        private final TreeMap<Integer, TDoubleArrayList> values;

        public EstimatorBoxplotAggregator(int[] axisLengths) {
            super("boxplot", 10000, -1);
            this.visitor = this;
            this.boxplotTmpDataGenericDataTensor = (GenericDataTensor)new GenericDataTensor.Builder<BoxplotTmpData>().clazz(BoxplotTmpData.class).axisLengths(axisLengths).build();
            this.setTensorLength(this.boxplotTmpDataGenericDataTensor.tensorSize);
            this.values = new TreeMap();
        }

        @Override
        public void handle(int[] coords, double value) throws IOException {
            BoxplotTmpData boxplotTmpData = this.boxplotTmpDataGenericDataTensor.getOrDefault(coords, new BoxplotTmpData(false));
            boxplotTmpData.aggr(value);
            if (this.needFlush()) {
                this.flushDoubleToDisk(this.values);
            }
            this.values.computeIfAbsent(this.boxplotTmpDataGenericDataTensor.loc(coords), locInfo -> new TDoubleArrayList(10, Double.NaN)).add(value);
        }

        @Override
        public void end() throws IOException {
            if (this.hasBeenFlushed()) {
                this.flushDoubleToDisk(this.values);
                this.readValues(false, true);
            }
        }

        @Override
        protected boolean isLocationEmpty(int i) {
            return ((BoxplotTmpData[])this.boxplotTmpDataGenericDataTensor.tensor)[i] == null;
        }

        @Override
        public boolean merge(PTBoxplotsRequest request, int[] origCoordinates, GenericDataTensor<BoxplotTmpData> destTensor, int[] targetCoordinates, AxisHandler.Axis[] axes) throws IOException {
            for (int i = 0; i < axes.length; ++i) {
                if (targetCoordinates[i] != axes[i].nbNotCutoff || request.axes[i].sortPrune.generateOthersCategory) continue;
                return false;
            }
            if (this.boxplotTmpDataGenericDataTensor.get(origCoordinates) != null) {
                BoxplotTmpData boxplotTmpData = destTensor.getOrDefault(targetCoordinates, new BoxplotTmpData(false));
                this.readValues(this.boxplotTmpDataGenericDataTensor.loc(origCoordinates), new MergeVisitor(boxplotTmpData));
            }
            return true;
        }

        @Override
        public void readValues(int loc, FlushableAggregator.Visitor visitor) throws IOException {
            if (!this.values.isEmpty()) {
                TDoubleArrayList valuesForLoc = this.values.get(loc);
                if (valuesForLoc == null) {
                    return;
                }
                visitor.beginRead(loc, valuesForLoc.size());
                TDoubleIterator iterator = valuesForLoc.iterator();
                while (iterator.hasNext()) {
                    visitor.handleDouble(iterator.next());
                }
                visitor.endRead(loc);
            }
            super.readValues(loc, visitor);
        }

        @Override
        public GenericDataTensor<PTBoxplotsResponse.Boxplot> mergeEnd(GenericDataTensor<BoxplotTmpData> destTensor, LongDataTensor counts) {
            GenericDataTensor dataTensor = (GenericDataTensor)new GenericDataTensor.Builder<PTBoxplotsResponse.Boxplot>().clazz(PTBoxplotsResponse.Boxplot.class).axisLengths(destTensor.axisLengths).build();
            for (int i = 0; i < destTensor.getTensor().length; ++i) {
                BoxplotTmpData boxplotTmpData = (BoxplotTmpData)destTensor.get(i);
                if (boxplotTmpData == null) continue;
                dataTensor.set(i, new PTBoxplotsResponse.Boxplot(), true);
                boxplotTmpData.fill((PTBoxplotsResponse.Boxplot)dataTensor.get(i));
            }
            return dataTensor;
        }

        @Override
        public void handleString(String value) throws IOException {
        }

        @Override
        public void handleDouble(double value) throws IOException {
        }

        @Override
        public void beginRead(int location, int length) {
        }

        @Override
        public void endRead(int location) {
        }

        @Override
        public void close() throws Exception {
            super.close();
        }

        public class MergeVisitor
        implements FlushableAggregator.Visitor {
            private final BoxplotTmpData boxplotTmpData;

            public MergeVisitor(BoxplotTmpData boxplotTmpData) {
                this.boxplotTmpData = boxplotTmpData;
            }

            @Override
            public void handleString(String value) throws IOException {
            }

            @Override
            public void handleDouble(double value) throws IOException {
                this.boxplotTmpData.aggr(value);
            }

            @Override
            public void beginRead(int location, int length) {
            }

            @Override
            public void endRead(int location) {
            }
        }
    }
}

