/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.pivot.backend.dss.PivotUtils;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.facet.CountMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.mutable.MutableInt;

public class AnumAxisFaceter
implements AxisFaceter {
    private final RowFilter filter;
    CountMap<String> counts = new CountMap();

    public AnumAxisFaceter(RowFilter filter) {
        this.filter = filter;
    }

    private void observe(String v) {
        if (v == null || v.isEmpty()) {
            this.counts.inc("___dku_no_value___");
        } else {
            this.counts.inc(v);
        }
    }

    @Override
    public void observe(ColumnBlock block, boolean[] filters) {
        if (block.getMemoryType() == ColumnBlock.MemoryType.STRING) {
            for (int i = 0; i < block.nbRecords(); ++i) {
                if (filters != null && !filters[i]) continue;
                this.observe(block.getAsStringSlow(i));
            }
        } else {
            throw new NotImplementedException(String.format("Type mismatch, found type: %s but the filter: %s type is supposed to be: %s", new Object[]{block.getMemoryType(), this.filter.column, this.filter.columnType}));
        }
    }

    @Override
    public FilterFacet compute(boolean shouldKeepRelevantValuesOnly) {
        FilterFacet ff = new FilterFacet();
        for (Map.Entry<String, MutableInt> count : this.counts.getMap().entrySet()) {
            boolean isNonRelevant;
            boolean bl = isNonRelevant = count.getValue().longValue() == 0L;
            if (isNonRelevant && shouldKeepRelevantValuesOnly) continue;
            ff.values.add(new FilterFacet.Val(count.getKey(), count.getKey(), count.getValue().longValue()));
        }
        ff.values.sort(PivotUtils.buildStringComparator(Objects.requireNonNullElse(this.filter.facetSorting, ChartFilter.FilterSortingOptions.COUNT_DESC)));
        return ff;
    }
}

