/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.dss.facets;

import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.io.ColumnBlock;
import com.dataiku.dip.io.LinoReader;
import com.dataiku.dip.pivot.backend.dss.facets.AxisFilter;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFaceter;
import com.dataiku.dip.pivot.backend.model.RowFilter;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.utils.DKUtils;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;

public class ExplicitConditionsFilter
implements AxisFilter {
    private RowFilter filter;
    private Calendar calendar = DKUtils.getUTCCalendar();

    public ExplicitConditionsFilter(RowFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean filter(Row row) {
        throw new Error();
    }

    @Override
    public void filter(LinoReader reader, int blockIdx, boolean[] ret) throws IOException {
        ArrayList<ColumnBlock> blocks = new ArrayList<ColumnBlock>();
        for (ChartFilter.ExplicitCondition cond : this.filter.explicitConditions) {
            blocks.add(reader.readColumnBlock(cond.column, blockIdx));
        }
        HashMap parsedSingleValues = Maps.newHashMap();
        for (int i = 0; i < ((ColumnBlock)blocks.get(0)).nbRecords(); ++i) {
            if (!ret[i]) continue;
            boolean matches = true;
            block8: for (int c2 = 0; c2 < this.filter.explicitConditions.size(); ++c2) {
                ChartFilter.ExplicitCondition cond = this.filter.explicitConditions.get(c2);
                ColumnBlock columnBlock = (ColumnBlock)blocks.get(c2);
                switch (cond.columnType) {
                    case ALPHANUM: {
                        double ts;
                        if (columnBlock.getMemoryType() == ColumnBlock.MemoryType.DOUBLE) {
                            Double parsedLabel;
                            ts = columnBlock.doubles[i];
                            String label = cond.singleValue;
                            if (label == null) continue block8;
                            if (!parsedSingleValues.containsKey(label)) {
                                Double value = ExplicitConditionsFilter.parseDoubleOrNull(label);
                                parsedSingleValues.put(label, value);
                            }
                            if ((parsedLabel = (Double)parsedSingleValues.get(label)) == null) continue block8;
                            matches &= parsedLabel.equals(ts);
                            continue block8;
                        }
                        String s = columnBlock.getAsStringSlow(i);
                        matches &= cond.singleValue.equals(s) || "___dku_no_value___".equals(cond.singleValue) && StringUtils.isBlank((String)s);
                        continue block8;
                    }
                    case DATE: {
                        double ts = columnBlock.doubles[i];
                        if (Double.isNaN(ts)) {
                            matches = false;
                            continue block8;
                        }
                        if (cond.dateFilterType == ChartFilter.DateFilterType.RANGE) {
                            if (cond.minValue != null && ts < cond.minValue) {
                                matches = false;
                            }
                            if (cond.maxValue == null || !(ts > cond.maxValue)) continue block8;
                            matches = false;
                            continue block8;
                        }
                        if (cond.dateFilterType == ChartFilter.DateFilterType.PART) {
                            long excludedBinId = Long.parseLong(cond.singleValue);
                            long currentBinId = DateAxisFaceter.getBinId(cond.dateFilterPart, (long)ts, this.calendar);
                            if (currentBinId == excludedBinId) continue block8;
                            matches = false;
                            continue block8;
                        }
                        throw new Error("not implemented");
                    }
                    case NUMERICAL: {
                        boolean hasMaxValue;
                        double d = columnBlock.doubles[i];
                        boolean hasMinValue = cond.minValue != null;
                        boolean bl = hasMaxValue = cond.maxValue != null;
                        if (Double.isNaN(d)) {
                            if (!hasMinValue && !hasMaxValue) continue block8;
                            matches = false;
                            continue block8;
                        }
                        if (hasMinValue && d < cond.minValue) {
                            matches = false;
                        }
                        if (hasMaxValue && d > cond.maxValue) {
                            matches = false;
                        }
                        if (hasMinValue || hasMaxValue) continue block8;
                        matches = false;
                        continue block8;
                    }
                    case GEOMETRY: 
                    case GEOPOINT: {
                        throw new Error("unreachable");
                    }
                }
            }
            if ((!this.filter.explicitExclude || !matches) && (this.filter.explicitExclude || matches)) continue;
            ret[i] = false;
        }
    }

    private static Double parseDoubleOrNull(String label) {
        if (label == null || "___dku_no_value___".equals(label)) {
            return Double.NaN;
        }
        try {
            return Double.parseDouble(label);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }
}

