/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.backend.sql.cache;

import com.dataiku.dip.pivot.backend.model.PivotTableRequest;
import com.dataiku.dip.pivot.backend.model.PivotTableResponse;
import com.dataiku.dip.pivot.backend.sql.cache.LRUList;
import com.dataiku.dip.utils.JSON;
import org.apache.commons.lang.StringUtils;

public class PivotResponseCache {
    private LRUList<CachedItem> data;

    public PivotResponseCache(int size) {
        this.data = new LRUList(size);
    }

    public synchronized void put(PivotTableRequest req, PivotTableResponse resp) {
        CachedItem item = new CachedItem();
        item.req = req;
        item.resp = resp;
        this.data.addAndCollect(item);
    }

    public synchronized CachedItem findExactMatch(PivotTableRequest req) {
        for (CachedItem item : this.data) {
            if (!PivotResponseCache.equals(item.req, req)) continue;
            return item;
        }
        return null;
    }

    private static boolean equals(PivotTableRequest r1, PivotTableRequest r2) {
        return StringUtils.equals((String)JSON.json((Object)r1), (String)JSON.json((Object)r2));
    }

    static class CachedItem {
        public PivotTableResponse resp;
        public PivotTableRequest req;

        CachedItem() {
        }
    }
}

