/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.pivot.frontend;

import com.dataiku.dip.pivot.UnsupportedOperation;
import com.dataiku.dip.pivot.frontend.model.DimensionDef;
import com.dataiku.dip.pivot.frontend.model.MeasureDef;
import org.apache.commons.lang3.StringUtils;

public class ChartUtils {
    private static String computeMeasureName(MeasureDef measureDef, boolean canUseDisplayLabel) {
        if (canUseDisplayLabel && StringUtils.isNotBlank((CharSequence)measureDef.displayLabel)) {
            return measureDef.displayLabel;
        }
        switch (measureDef.function) {
            case COUNT: {
                return "Count of " + (measureDef.column != null ? measureDef.column : "records");
            }
            case COUNTD: {
                return "Count distinct of " + measureDef.column;
            }
            case SUM: {
                return "Sum of " + measureDef.column;
            }
            case AVG: {
                return "Average of " + measureDef.column;
            }
            case MEDIAN: {
                return "Median of " + measureDef.column;
            }
            case PERCENTILE: {
                return "Percentile (" + measureDef.percentile + ") of " + measureDef.column;
            }
            case MAX: 
            case OBJECT_MAX: {
                return "Maximum of " + measureDef.column;
            }
            case MIN: 
            case OBJECT_MIN: {
                return "Minimum of " + measureDef.column;
            }
            case STDEV: {
                return "Standard deviation of " + measureDef.column;
            }
            case STDEV_POPULATION: {
                return "Standard deviation (pop.) of " + measureDef.column;
            }
            case VARIANCE: {
                return "Variance of " + measureDef.column;
            }
            case VARIANCE_POPULATION: {
                return "Variance (pop.) of " + measureDef.column;
            }
            case CUSTOM: {
                return measureDef.column;
            }
        }
        throw new UnsupportedOperation("Excel chart export doesn't support aggregation function " + String.valueOf((Object)measureDef.function));
    }

    private static String computeDimensionName(DimensionDef dimensionDef, boolean canUseDisplayLabel) {
        if (canUseDisplayLabel && StringUtils.isNotBlank((CharSequence)dimensionDef.displayLabel)) {
            return dimensionDef.displayLabel;
        }
        return dimensionDef.column;
    }

    public static String getNiceMeasureName(MeasureDef measureDef, boolean canUseDisplayLabel) {
        return ChartUtils.computeMeasureName(measureDef, canUseDisplayLabel);
    }

    public static String getNiceMeasureName(MeasureDef measureDef) {
        return ChartUtils.computeMeasureName(measureDef, true);
    }

    public static String getNiceDimensionName(DimensionDef dimensionDef, boolean canUseDisplayLabel) {
        return ChartUtils.computeDimensionName(dimensionDef, canUseDisplayLabel);
    }

    public static String getNiceDimensionName(DimensionDef dimensionDef) {
        return ChartUtils.computeDimensionName(dimensionDef, true);
    }
}

