/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.plugin.tools;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.SinkProcessorOutput;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.plugin.CustomFormat;
import com.dataiku.dip.plugin.CustomFormatInput;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.plugin.tools.RunBase;
import com.dataiku.dip.plugin.tools.SchemaFromCli;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class RunInput
extends RunBase {
    private final Schema schema;

    public RunInput(CommandLine cmdLine, int formatClassPos) {
        super(cmdLine, formatClassPos);
        this.schema = SchemaFromCli.getSchema(cmdLine);
    }

    RunInput(String formatClass, String classesDir, String jarFilePath, String libPath, Schema schema, String config, String pluginConfig) {
        super(formatClass, classesDir, jarFilePath, libPath, config, pluginConfig);
        this.schema = schema;
    }

    public void run() throws Exception {
        CustomFormat format = this.getFormat();
        StreamColumnFactory cf = new StreamColumnFactory();
        StreamRowFactory rf = new StreamRowFactory();
        SystemOutProcessorOutput out = new SystemOutProcessorOutput((ColumnFactory)cf);
        try (CustomFormatInput reader = format.getReader(this.config, this.pluginConfig);){
            if (this.schema != null) {
                reader.setSchema(this.schema, true);
            }
            reader.run(new InputStreamWithContextInfo(System.in, "stdin", "stdin", null, () -> 0L), (ProcessorOutput)out, (ColumnFactory)cf, (RowFactory)rf);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println(Joiner.on((String)"\", \"").join((Object[])args));
        System.out.println();
        RunBase.init();
        Options opts = new Options();
        RunBase.fillOptions(opts);
        SchemaFromCli.fillOptions(opts);
        try {
            CommandLine cmdLine = new DefaultParser().parse(opts, args);
            if (cmdLine.getArgs().length == 0) {
                RunInput.usage(opts);
            } else {
                new RunInput(cmdLine, 0).run();
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            RunInput.usage(opts);
            System.exit(1);
        }
    }

    private static void usage(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("test-input", "Test a format input on the standard input and writes the result to the standard output", opts, "", true);
    }

    private static class SystemOutProcessorOutput
    extends SinkProcessorOutput {
        private final ColumnFactory cf;
        private final List<Column> columns = Lists.newArrayList();
        private final Set<String> columnNames = Sets.newHashSet();

        SystemOutProcessorOutput(ColumnFactory cf) {
            this.cf = cf;
        }

        public void emitRow(Row row) throws Exception {
            boolean schemaChanged = false;
            for (Column column : this.cf.columns()) {
                if (this.columnNames.contains(column.getName())) continue;
                this.columnNames.add(column.getName());
                this.columns.add(column);
                System.out.println(">>>> new column : " + column.getName());
                schemaChanged = true;
            }
            if (schemaChanged) {
                ArrayList colNameList = Lists.newArrayList();
                for (Column column : this.columns) {
                    colNameList.add(column.getName());
                }
                System.out.println(Joiner.on((String)"\t").join((Iterable)colNameList));
            }
            ArrayList values = Lists.newArrayList();
            for (Column column : this.columns) {
                String value = row.get(column);
                if (value != null) {
                    values.add(value);
                    continue;
                }
                values.add("");
            }
            System.out.println(Joiner.on((String)"\t").join((Iterable)values));
        }
    }
}

