/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projects.importexport;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.projects.importexport.ExportedProject;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class AutoMigrator {
    private File bundlePath;
    private ExportedProject ep;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.bundles.migration");

    public AutoMigrator(File bundlePath, ExportedProject ep) {
        this.bundlePath = bundlePath;
        this.ep = ep;
    }

    public String getMigrateFrom() {
        this.inferConfVersion();
        String thisDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        if (!this.ep.generatedWithDSSConfVersion.equals(thisDSSConfVersion)) {
            logger.infoV("Project needs migration (generated with DSS=%s conf=%s thisDSS conf=%s)", new Object[]{this.ep.generatedWithDSSVersion, this.ep.generatedWithDSSConfVersion, thisDSSConfVersion});
            if (this.ep.generatedWithDSSVersion != null) {
                return this.ep.generatedWithDSSVersion;
            }
            return "Unknown (conf_version=" + this.ep.generatedWithDSSConfVersion + ")";
        }
        return null;
    }

    private void inferConfVersion() {
        if (StringUtils.isBlank((String)this.ep.generatedWithDSSConfVersion)) {
            logger.warn((Object)"Project without conf version, infering from DSS version");
            if (this.ep.generatedWithDSSVersion.startsWith("2.0")) {
                logger.warn((Object)"Detected 2.0 -> Conf 8");
                this.ep.generatedWithDSSConfVersion = "8";
            } else if (this.ep.generatedWithDSSVersion.startsWith("2.1")) {
                logger.warn((Object)"Detected 2.1 -> Conf 9");
                this.ep.generatedWithDSSConfVersion = "9";
            } else {
                throw new IllegalArgumentException("Can't migrate from project generated with DSS " + this.ep.generatedWithDSSVersion);
            }
        }
    }

    public boolean migrateIfNeeded() throws IOException, InterruptedException {
        if (new File(this.bundlePath, "already-migrated.txt").isFile()) {
            logger.infoV("Already migrated, no need to migrate again", new Object[0]);
            return false;
        }
        this.inferConfVersion();
        String thisDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        logger.infoV("Project generated with DSS=%s conf=%s thisDSS conf=%s", new Object[]{this.ep.generatedWithDSSVersion, this.ep.generatedWithDSSConfVersion, thisDSSConfVersion});
        if (!this.ep.generatedWithDSSConfVersion.equals(thisDSSConfVersion)) {
            logger.infoV("Project needs migration (generated with DSS=%s conf=%s thisDSS conf=%s)", new Object[]{this.ep.generatedWithDSSVersion, this.ep.generatedWithDSSConfVersion, thisDSSConfVersion});
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            File migrationScript = System.getenv("DSS_DEV") != null ? ApplicationConfigurator.getInstallFile((String[])new String[]{"packagers", "dkuinstall", "migrate_project_import.py"}) : ApplicationConfigurator.getInstallFile((String[])new String[]{"scripts", "dkuinstall", "migrate_project_import.py"});
            pb.command(System.getenv("DKUPYTHONBIN"), migrationScript.getAbsolutePath(), this.bundlePath.getAbsolutePath(), this.ep.generatedWithDSSConfVersion);
            if (System.getenv("DSS_DEV") != null) {
                pb.environment().put("PYTHONPATH", ApplicationConfigurator.getInstallFolder() + "/packagers");
            } else {
                pb.environment().put("PYTHONPATH", ApplicationConfigurator.getInstallFolder() + "/scripts");
            }
            pb.environment().put("DKU_ORIGINAL_PROJECT_KEY", this.ep.originalProjectKey);
            DKUtils.execAndLogThrows((ProcessBuilder)pb);
            DKUFileUtils.writeFileUTF8((File)new File(this.bundlePath, "already-migrated.txt"), (String)("From " + this.ep.generatedWithDSSVersion + " on " + DKUDateUtils.isoFormatLocalNow()));
            return true;
        }
        return false;
    }
}

