/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.projectstandards;

import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckRunResult;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProjectStandardsRunReportSummary {
    public final String projectKey;
    @Nullable
    public final String scope;
    public final String requester;
    public final Map<Integer, Long> nbOfChecksBySeverity;
    public final long nbOfChecksInError;
    public final long nbOfChecksNotApplicable;
    public final String startTime;
    public final long totalDurationMs;

    public ProjectStandardsRunReportSummary(@Nonnull ProjectStandardsRunReport report) {
        this.projectKey = report.projectKey;
        this.scope = report.scope;
        this.requester = report.requester;
        this.startTime = report.startTime;
        this.totalDurationMs = report.totalDurationMs;
        Collection<ProjectStandardsCheckRunInfo> runInfos = report.bundleChecksRunInfo.values();
        this.nbOfChecksInError = runInfos.stream().filter(run -> run.result.status == ProjectStandardsCheckRunResult.ProjectStandardsCheckRunStatus.RUN_ERROR).count();
        this.nbOfChecksNotApplicable = runInfos.stream().filter(run -> run.result.status == ProjectStandardsCheckRunResult.ProjectStandardsCheckRunStatus.NOT_APPLICABLE).count();
        this.nbOfChecksBySeverity = runInfos.stream().filter(run -> run.result.status == ProjectStandardsCheckRunResult.ProjectStandardsCheckRunStatus.RUN_SUCCESS).map(run -> run.result.severity).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (int severity = 0; severity < 6; ++severity) {
            this.nbOfChecksBySeverity.putIfAbsent(severity, 0L);
        }
    }
}

