/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.julia;

import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.code.AbstractCodeBasedRecipeStatusComputer;
import com.dataiku.dip.recipes.code.CodeBasedRecipeStatus;
import com.dataiku.dip.recipes.code.julia.JuliaRecipeMeta;
import com.dataiku.dip.recipes.common.RecipeStatus;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public class JuliaRecipeStatusComputer
extends AbstractCodeBasedRecipeStatusComputer {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GenericRecipesValidationService validationService;

    public JuliaRecipeStatusComputer(SerializedRecipe recipe, String payload) {
        super(recipe, payload);
    }

    @Override
    public RecipeStatus getFullStatus_NT(AuthCtx authCtx, String requestData) throws Exception {
        CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest request = (CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest)JSON.parse((String)requestData, CodeBasedRecipeStatus.CodeBasedRecipeStatusRequest.class);
        RecipeRunnableSubgraph subgraph = null;
        if (request != null) {
            SingleWriteTransactionTransactionService.DetransactionalizedCallable<RecipeRunnableSubgraph> subgraphCallable;
            try (Transaction t = this.transactionService.beginRead();){
                FlowGraph graph = new FlowGraph();
                FlowRecipe fr = graph.buildSingleRecipe(this.recipe);
                subgraphCallable = this.validationService.getValidationRunnableSubgraph(authCtx, fr, request.targetPartitionSpec);
            }
            subgraph = subgraphCallable.call_NT();
        }
        try (Transaction t = this.transactionService.beginRead();){
            CodeBasedRecipeStatus codeBasedRecipeStatus;
            CodeBasedRecipeStatus ret = this.fastStatusIgnorePartitions(authCtx);
            this.checkContainerConfiguration(authCtx, ret, this.recipe.getParamsAs(JuliaRecipeMeta.JuliaRecipeParams.class), null);
            if (ret.topLevelMessages.anyFatal()) {
                codeBasedRecipeStatus = ret;
                return codeBasedRecipeStatus;
            }
            if (request != null) {
                this.addVariablesSubstitutionWithoutCheck(authCtx, ret, subgraph);
            }
            ret.topLevelMessages.withWarning((InfoMessage.MessageCode)RecipeCodes.WARN_RECIPE_CODE_NOT_CHECKED, "Code of Julia recipes is not checked - only global consistency checks were performed");
            codeBasedRecipeStatus = ret;
            return codeBasedRecipeStatus;
        }
    }

    @Override
    public CodeBasedRecipeStatus fastStatusIgnorePartitions(AuthCtx authCtx) throws IOException, DKUSecurityException {
        CodeBasedRecipeStatus ret = new CodeBasedRecipeStatus();
        this.performBasicStructureChecks(ret, authCtx);
        ret.addSingleEngine("USER_CODE", "User code", "JULIA", "Julia", "Julia (user code)");
        return ret;
    }
}

