/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.code.shell;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.common.CodeBasedThingHelper;
import com.dataiku.dip.dataflow.common.JobProcessExecution;
import com.dataiku.dip.dataflow.exec.AbstractCodeBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.RecipeRunnerWithPayload;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.jobrunner.JobContext;
import com.dataiku.dip.dataflow.kernel.slave.KernelSession;
import com.dataiku.dip.dataflow.streaming.DatasetWriter;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.ManagedDatasetsHelper;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.input.formats.csv.RFC4180CSVParser;
import com.dataiku.dip.input.stream.InputStreamLineReader;
import com.dataiku.dip.input.stream.LineReader;
import com.dataiku.dip.output.CSVOutputFormatter;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.output.OutputFormatter;
import com.dataiku.dip.output.OutputStreamOutputWriter;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.code.shell.ShellRecipeHelper;
import com.dataiku.dip.recipes.code.shell.ShellScriptRecipeMeta;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.SingleWriteTransactionTransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.transactions.ifaces.TransactionRef;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringTransmogrifier;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.types.Commandline;
import org.springframework.beans.factory.annotation.Autowired;

public class ShellScriptRecipeRunner
extends AbstractCodeBasedRecipeRunner
implements RecipeRunnerWithPayload {
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private SingleWriteTransactionTransactionService singleWTxService;
    private final ShellRecipeHelper helper = new ShellRecipeHelper();
    private String scriptData;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.shell");

    public ShellScriptRecipeRunner(JobActivity activity) {
        super(activity);
    }

    @Override
    public void setPayload(String payload) {
        logger.info((Object)("SET PAYLOAD " + payload));
        if (StringUtils.isBlank((String)payload)) {
            throw new Error("Could not find script for " + this.recipe.getName() + ", or script is empty.");
        }
        this.scriptData = payload;
    }

    @Override
    public synchronized void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }

    private Map<String, String> getVariablesForFlow() throws CodedException, IOException, DKUSecurityException, InterruptedException {
        AuthCtx authCtx = this.authCtxService.getAuthCtx();
        this.singleWTxService.stashTheSingleTransaction();
        try {
            Map<String, String> map = this.helper.getVariablesForFlow_NT(authCtx, (RecipeRunnableSubgraph)this.subgraph, this.recipe.getModel());
            return map;
        }
        finally {
            this.singleWTxService.unstashTheSingleTransaction();
        }
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        stash.env.putAll(this.getVariablesForFlow());
        if (stash.flowVariables != null) {
            for (Map.Entry<String, Object> entry : stash.flowVariables.entrySet()) {
                stash.env.put(entry.getKey(), (String)entry.getValue());
            }
        }
        if (stash.customVariables != null) {
            for (Map.Entry<String, Object> entry : stash.customVariables.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    try {
                        StringWriter wr = new StringWriter();
                        try {
                            JSON.UnicodeEscapingWriter uew = new JSON.UnicodeEscapingWriter((Writer)wr);
                            try {
                                uew.write((String)value);
                                stash.env.put("DKU_CUSTOM_VARIABLES_" + entry.getKey(), wr.toString());
                                continue;
                            }
                            finally {
                                uew.close();
                                continue;
                            }
                        }
                        finally {
                            wr.close();
                            continue;
                        }
                    }
                    catch (IOException e) {
                        throw new RuntimeException("The impossible happened", e);
                    }
                }
                if (value instanceof Boolean) {
                    stash.env.put("DKU_CUSTOM_VARIABLES_" + entry.getKey(), JSON.json((Object)value));
                    continue;
                }
                if (value instanceof Number) {
                    stash.env.put("DKU_CUSTOM_VARIABLES_" + entry.getKey(), JSON.json((Object)value));
                    continue;
                }
                stash.env.put("DKU_CUSTOM_VARIABLES_" + entry.getKey(), JSON.jsonWithUnicodeEscaped((Object)entry.getValue()));
            }
        }
        return stash;
    }

    @Override
    protected JobProcessExecution getProcessExecution() {
        return new JobProcessExecution(this.authCtxService.getAuthCtx(), this.projectKey){

            @Override
            protected void prepareExecOutputConsumer(DKUtils.ExecOutputConsumer eoc, DKUtils.LineSubscription fwr) throws Exception {
                ShellScriptRecipeMeta.ShellScriptRecipeParams params = (ShellScriptRecipeMeta.ShellScriptRecipeParams)((ShellScriptRecipeRunner)ShellScriptRecipeRunner.this).recipe.getModel().params;
                if (params.pipeOut != null && params.pipeOut.length() > 0) {
                    SerializedRecipe.RecipeOutput pipedOutput;
                    Map<String, FlowComputable> outputToComputable = ShellScriptRecipeRunner.this.helper.buildRecipeOutputToComputableMap((RecipeRunnableSubgraph)ShellScriptRecipeRunner.this.subgraph, ShellScriptRecipeRunner.this.recipe.getModel());
                    FlowComputable flowTarget = outputToComputable.get((pipedOutput = new SerializedRecipe.RecipeOutput(params.pipeOut)).getLoc(ShellScriptRecipeRunner.this.recipe.getProjectKey()).getFullName());
                    if (flowTarget == null) {
                        throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Cannot find the piped-out dataset " + params.pipeOut);
                    }
                    if (!(flowTarget instanceof FlowDataset)) {
                        throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "The piped-out target " + params.pipeOut + " is not a dataset");
                    }
                    Dataset dataset = ((FlowDataset)flowTarget).getMandatory(ShellScriptRecipeRunner.this.datasetsDAO);
                    Partition partition = ShellScriptRecipeRunner.this.subgraph.getTargetPartition(flowTarget);
                    PipeOutThread thread = new PipeOutThread(dataset, partition, params.autoInferSchema, params.expectHeaders, TransactionContext.retrieveWrite());
                    eoc.withOutputConsumer((DKUtils.ExecSubscription)thread);
                    thread.start();
                } else {
                    super.prepareExecOutputConsumer(eoc, fwr);
                }
            }
        };
    }

    @Override
    public void run() throws Exception {
        File logFile = FlowJobUtils.getJobTouchedFile("shell-recipe", "process-out.log");
        JobContext.getCurrentActivityObj().getStatus().addStatutOutput("Shell output", logFile, "text/plain");
        try (AutoDelete tmpFolder = FlowJobUtils.getTmpFolder("shell-recipe", "run");){
            logger.info((Object)("Dumping the script into the temporary folder into: " + tmpFolder.getAbsolutePath()));
            File tmpScript = new File((File)tmpFolder, "script.sh");
            FileUtils.write((File)tmpScript, (CharSequence)this.scriptData);
            List<String> cmd = this.getShellCmd(this.scriptData);
            cmd.add(tmpScript.getAbsolutePath());
            this.activity.setStatusMessage("Running shell script");
            ProcessBuilder builder = new ProcessBuilder(new String[0]);
            builder.directory((File)tmpFolder);
            builder.environment().putAll(this.prepareEnvStash((File)tmpFolder, new HashMap<String, String>(), null, null).getAsEnvVariables(true, true, true));
            builder.command(cmd);
            CodeBasedThingHelper.OptionalInputFactory optionalInput = null;
            Map<String, FlowComputable> inputToComputable = this.helper.buildRecipeInputToComputableMap((RecipeRunnableSubgraph)this.subgraph, this.recipe.getModel());
            ShellScriptRecipeMeta.ShellScriptRecipeParams params = (ShellScriptRecipeMeta.ShellScriptRecipeParams)this.recipe.getModel().params;
            if (params.pipeIn != null && params.pipeIn.length() > 0) {
                SerializedRecipe.RecipeInput pipedInput = new SerializedRecipe.RecipeInput(params.pipeIn);
                FlowComputable flowSource = inputToComputable.get(pipedInput.getLoc(this.recipe.getProjectKey()).getFullName());
                if (flowSource == null) {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "Cannot find the piped-in dataset " + params.pipeIn);
                }
                if (!(flowSource instanceof FlowDataset)) {
                    throw new CodedException((InfoMessage.MessageCode)RecipeCodes.ERR_RECIPE_INCONSISTENT_I_O, "The piped-in source " + params.pipeIn + " is not a dataset");
                }
                final Dataset dataset = ((FlowDataset)flowSource).getMandatory(this.datasetsDAO);
                final List<Partition> partitions = this.subgraph.getSourcePartitions(flowSource);
                final boolean sendHeaders = params.sendHeaders;
                optionalInput = new CodeBasedThingHelper.OptionalInputFactory(){

                    @Override
                    public Thread prepareInputFeeder(OutputStream outputStream) {
                        return new PipeInThread(dataset, partitions, outputStream, sendHeaders, TransactionContext.retrieveWrite());
                    }
                };
            }
            this.execute(builder, logFile, optionalInput, "shell", GeneralSettingsDAO.CGrouppableProcessType.PYTHON_R_RECIPE, false);
            this.activity.setAllSourcesCompletelyRead();
            this.activity.fillTargetWrittenSizes(this.datasetsDAO);
            this.activity.setStatusMessage("Done");
        }
    }

    private List<String> getShellCmd(String script) {
        ArrayList cmd = Lists.newArrayList();
        ShellScriptRecipeMeta.ShellScriptRecipeParams params = (ShellScriptRecipeMeta.ShellScriptRecipeParams)this.recipe.getModel().params;
        if (params.shellBinary != null && params.shellBinary.length() > 0) {
            logger.info((Object)("Running Script with : " + params.shellBinary));
            for (String arg : Commandline.translateCommandline((String)params.shellBinary)) {
                cmd.add(arg);
            }
        } else {
            String line;
            boolean hasShebang = false;
            Scanner scanner = new Scanner(script);
            if (scanner.hasNextLine() && (line = scanner.nextLine()).trim().startsWith("#!")) {
                String command = line.trim().substring(2);
                logger.info((Object)("Running Script with : " + command));
                for (String arg : Commandline.translateCommandline((String)command)) {
                    cmd.add(arg);
                }
                hasShebang = true;
            }
            scanner.close();
            if (!hasShebang) {
                logger.info((Object)"Running Script with : /bin/sh");
                cmd.add("/bin/sh");
            }
        }
        return cmd;
    }

    private class PipeOutThread
    extends Thread
    implements DKUtils.BytesSubscription {
        private final Dataset dataset;
        private final Partition partition;
        private final PipedOutputStream writeToScriptOutput;
        private final InputStream scriptOutput;
        private final StreamColumnFactory columnFactory;
        private final StreamRowFactory rowFactory;
        private final boolean autoInferSchema;
        private final boolean expectHeaders;
        private final RWTransactionRef t;
        private boolean success;

        public PipeOutThread(Dataset dataset, Partition partition, boolean autoInferSchema, boolean expectHeaders, RWTransactionRef t) throws IOException {
            this.dataset = dataset;
            this.partition = partition;
            this.writeToScriptOutput = new PipedOutputStream();
            this.scriptOutput = new PipedInputStream(this.writeToScriptOutput, 0x100000);
            this.autoInferSchema = autoInferSchema;
            this.expectHeaders = expectHeaders;
            this.t = t;
            this.columnFactory = new StreamColumnFactory();
            this.rowFactory = new StreamRowFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionContext.attach((TransactionRef)this.t);
            try {
                InputStreamLineReader islr = new InputStreamLineReader((InputStream)new BufferedInputStream(this.scriptOutput), StandardCharsets.UTF_8);
                RFC4180CSVParser csvParser = new RFC4180CSVParser((LineReader)islr, '\t');
                ArrayList<String> rowBuffer = new ArrayList<String>();
                ArrayList<Column> columns = new ArrayList<Column>();
                if (this.autoInferSchema) {
                    try {
                        if (csvParser.next(rowBuffer)) {
                            List existingColumns = this.dataset.getSchema().getColumns();
                            ArrayList suggestedColumns = Lists.newArrayList();
                            if (this.expectHeaders) {
                                for (String columnName : rowBuffer) {
                                    suggestedColumns.add(new SchemaColumn(columnName, Type.STRING));
                                }
                            } else {
                                for (int i = 0; i < rowBuffer.size(); ++i) {
                                    suggestedColumns.add(new SchemaColumn("col_" + i, Type.STRING));
                                }
                            }
                            StringTransmogrifier transmogrifier = new StringTransmogrifier();
                            HashSet existingColumnsNames = Sets.newHashSet();
                            for (SchemaColumn c2 : existingColumns) {
                                transmogrifier.addAlreadyTransmogrified(c2.getName());
                                existingColumnsNames.add(c2.getName());
                            }
                            Schema schema = new Schema();
                            for (int i = 0; i < Math.max(existingColumns.size(), suggestedColumns.size()); ++i) {
                                SchemaColumn suggestedColumn;
                                if (i < suggestedColumns.size() && i < existingColumns.size()) {
                                    suggestedColumn = (SchemaColumn)suggestedColumns.get(i);
                                    if (this.expectHeaders) {
                                        String suggestedName = suggestedColumn.getName();
                                        String newName = existingColumnsNames.contains(suggestedName) ? suggestedName : transmogrifier.transmogrify(suggestedName);
                                        schema.addColumn(newName, suggestedColumn.getType());
                                        continue;
                                    }
                                    schema.addColumn((SchemaColumn)existingColumns.get(i));
                                    continue;
                                }
                                if (i < suggestedColumns.size()) {
                                    suggestedColumn = (SchemaColumn)suggestedColumns.get(i);
                                    schema.addColumn(transmogrifier.transmogrify(suggestedColumn.getName()), suggestedColumn.getType());
                                    continue;
                                }
                                schema.addColumn((SchemaColumn)existingColumns.get(i));
                            }
                            String oldSchema = JSON.json((Object)this.dataset.getSchema());
                            logger.info((Object)"Overriding the schema of the dataset");
                            Dataset outputDataset = Dataset.fromSerialized(this.dataset.serialize());
                            outputDataset.setSchema(schema);
                            ManagedDatasetsHelper.copySchema(ShellScriptRecipeRunner.this.authCtxService.getAuthCtx(), outputDataset.getSchema(), this.dataset);
                            schema = this.dataset.getSchema();
                            if (!JSON.json((Object)schema).equals(oldSchema)) {
                                KernelSession.propagateSchemaToJekOrBackend(this.dataset.getFullName(), schema);
                                ShellScriptRecipeRunner.this.datasetsDAO.save(this.dataset.serialize());
                            }
                            for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                                columns.add((Column)this.columnFactory.column(sc.getName()));
                            }
                        }
                        if (this.expectHeaders) {
                            throw new Exception("The script didn't publish any data on its output, expected at least a header line");
                        }
                        logger.info((Object)"Could not read first line of output to detect the schema");
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error while reading first line of output to detect the schema", (Throwable)e);
                        this.success = false;
                        TransactionContext.detach((TransactionRef)this.t);
                        try {
                            logger.info((Object)"Close the script output");
                            this.scriptOutput.close();
                        }
                        catch (IOException e2) {
                            logger.error((Object)"Error while closing the output from script", (Throwable)e2);
                            this.success = false;
                        }
                        return;
                    }
                } else {
                    for (SchemaColumn sc : this.dataset.getSchema().getColumns()) {
                        columns.add((Column)this.columnFactory.column(sc.getName()));
                    }
                }
                try (DatasetWriter writer = DatasetWriter.build(ShellScriptRecipeRunner.this.authCtxService.getAuthCtx(), this.dataset, this.partition, ((ShellScriptRecipeRunner)ShellScriptRecipeRunner.this).activity.warnContext, Output.WriteMode.OVERWRITE, null, (ColumnFactory)this.columnFactory);){
                    if (this.autoInferSchema && !this.expectHeaders) {
                        this.outputRow(rowBuffer, columns, writer);
                    }
                    while (csvParser.next(rowBuffer)) {
                        this.outputRow(rowBuffer, columns, writer);
                    }
                    this.success = true;
                }
                catch (Exception e) {
                    logger.error((Object)"Error while reading output from script", (Throwable)e);
                    this.success = false;
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Failure during pipe out from shell script", e);
            }
            finally {
                TransactionContext.detach((TransactionRef)this.t);
                try {
                    logger.info((Object)"Close the script output");
                    this.scriptOutput.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error while closing the output from script", (Throwable)e);
                    this.success = false;
                }
            }
        }

        private void outputRow(List<String> rowBuffer, List<Column> columns, DatasetWriter writer) throws Exception {
            Row row = this.rowFactory.row();
            for (int i = 0; i < columns.size() && i < rowBuffer.size(); ++i) {
                row.put(columns.get(i), rowBuffer.get(i));
            }
            writer.appendRow(row);
        }

        public void handle(byte[] buffer, int count) throws IOException {
            this.writeToScriptOutput.write(buffer, 0, count);
        }

        public void close() throws IOException {
            this.writeToScriptOutput.close();
            try {
                this.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("Failed to finish piping the script output");
            }
            if (!this.success) {
                throw new IOException("Failed to pipe the script output");
            }
        }
    }

    private class PipeInThread
    extends Thread {
        private final Dataset dataset;
        private final List<Partition> partitions;
        private final OutputStream scriptInput;
        private final boolean sendHeaders;
        private final RWTransactionRef t;

        public PipeInThread(Dataset dataset, List<Partition> partitions, OutputStream scriptInput, boolean sendHeaders, RWTransactionRef t) {
            this.dataset = dataset;
            this.partitions = partitions;
            this.scriptInput = scriptInput;
            this.sendHeaders = sendHeaders;
            this.t = t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TransactionContext.attach((TransactionRef)this.t);
            try {
                StreamColumnFactory scf = new StreamColumnFactory();
                StreamRowFactory srf = new StreamRowFactory();
                CSVFormatConfig config = CSVFormatConfig.getStandardTabExcelFormat();
                config.setSeparatorStr("\t");
                config.parseHeaderRow = this.sendHeaders;
                CSVOutputFormatter formatter = new CSVOutputFormatter(config);
                formatter.setOutputSchema(this.dataset.getSchema());
                StreamableDatasetSelection sel = StreamableDatasetSelection.full();
                sel.withSelectedPartitions(this.partitions);
                OutputStreamOutputWriter osow = new OutputStreamOutputWriter(this.scriptInput, (OutputFormatter)formatter);
                try {
                    osow.init((ColumnFactory)scf);
                    UniversalSingleThreadPusher.push(ShellScriptRecipeRunner.this.authCtxService.getAuthCtx(), this.dataset, sel, (ProcessorOutput)osow, (ColumnFactory)scf, (RowFactory)srf);
                    osow.lastRowEmitted();
                }
                catch (Exception e) {
                    logger.error((Object)"Error while sending input to script", (Throwable)e);
                }
            }
            catch (Throwable e) {
                logger.error((Object)"Failure during pipe in to shell script", e);
            }
            finally {
                TransactionContext.detach((TransactionRef)this.t);
                try {
                    logger.info((Object)"Closing the script input");
                    this.scriptInput.close();
                }
                catch (IOException e) {
                    logger.error((Object)"Error while closing the input to script", (Throwable)e);
                }
            }
        }
    }
}

