/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.consistency;

import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dao.RecipesDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.recipes.RecipeDesc;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeSchemaComputer;
import com.dataiku.dip.recipes.consistency.RecipeCodes;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.recipes.GenericRecipesValidationService;
import com.dataiku.dip.server.recipes.RecipeSchemaService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class RecipeSchemaConsistencyChecker {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private RecipesDAO recipesDAO;
    @Autowired
    private GenericRecipesValidationService validationService;
    @Autowired
    private RecipeSchemaService recipeSchemaService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.flow.recipe.schema");

    public RecipeSchemaConsistencyChecker() {
        SpringUtils.getInstance().autowire((Object)this);
    }

    public RecipeSchemaService.RecipeSchemaAutoupdateResult checkRecipe(AuthCtx authCtx, FlowRecipe fr, boolean performExpensive) throws Exception {
        RecipeSchemaComputer computer;
        RecipeDesc desc;
        TransactionContext.assertNoAttachedTransaction();
        SerializedRecipe sr = fr.getModel();
        fr = new FlowRecipe(sr);
        try (Transaction t = this.transactionService.beginRead();){
            if (sr.getOutputsForRole("main").size() == 0) {
                throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY, "No main output ?");
            }
            JobActivity activity = new JobActivity(this.validationService.getSampleSubgraph(fr));
            RecipeMeta rm2 = RecipeRegistry.getMeta(activity);
            desc = rm2.getRecipeDesc();
            switch (rm2.getOutputSchemasComputability()) {
                case NONE: {
                    logger.warn((Object)("Cannot compute schema on " + rm2.getType()));
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_ON_RECIPE_TYPE, "Output schema can't be automatically computed on '" + rm2.getType() + "' recipes");
                }
                case RELIABLE_DYNAMIC: 
                case RELIABLE_STATIC: {
                    break;
                }
                case EXPENSIVE: {
                    if (performExpensive) break;
                    throw new RecipeSchemaComputer.DontWantToCompute(RecipeCodes.ERR_RECIPE_CANNOT_CHECK_SCHEMA_CONSISTENCY_EXPENSIVE, "'Expensive' checks are disabled");
                }
            }
            computer = rm2.buildSchemaComputer(authCtx, activity);
            if (computer instanceof RecipeSchemaComputer.RecipeSchemaComputerWithPayload) {
                String payload = this.recipesDAO.getPayloadOrNull(fr.getProjectKey(), fr.getName());
                ((RecipeSchemaComputer.RecipeSchemaComputerWithPayload)((Object)computer)).setPayload(payload);
            }
        }
        try {
            if (computer.computesDiffItself()) {
                return computer.getAutoupdateResult_NT();
            }
            RecipeSchemaService.RecipeSchemaAutoupdateResult ret = new RecipeSchemaService.RecipeSchemaAutoupdateResult();
            for (RecipeDesc.IORoleDef role : desc.outputRoles) {
                if (!role.hasSchema()) continue;
                List<Schema> computedSchemas = computer.getSchemasForOutputRole_NT(role.name);
                Transaction t = this.transactionService.beginRead();
                try {
                    ret.merge(this.recipeSchemaService.getSchemaUpdateResult(authCtx, sr, computedSchemas, role.name));
                }
                finally {
                    if (t == null) continue;
                    t.close();
                }
            }
            return ret;
        }
        catch (RecipeSchemaComputer.DontWantToCompute e) {
            logger.info((Object)("Schema computer decided he did not want to compute: " + e.getMessage()));
            throw e;
        }
    }
}

