/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.customcode;

import com.dataiku.dip.cluster.SparkSettings;
import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.exec.AbstractSparkBasedRecipeRunner;
import com.dataiku.dip.dataflow.exec.EnvironmentStash;
import com.dataiku.dip.dataflow.exec.SparkExecutionEnginesHelper;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.code.scala.CodeMode;
import com.dataiku.dip.recipes.code.spark.SparkRecipeUtils;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipeMeta;
import com.dataiku.dip.recipes.customcode.CustomCodeRecipesService;
import com.dataiku.dip.recipes.customcode.LoadedCustomCodeRecipeDesc;
import com.dataiku.dip.recipes.customcode.SparkCustomCodeRecipeParams;
import com.dataiku.dip.spark.SparkJob;
import com.dataiku.dip.spark.SparkJobHelper;
import com.dataiku.dip.spark.SparkOverrideConfig;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomSparkScalaRecipeRunner
extends AbstractSparkBasedRecipeRunner {
    @Autowired
    private CustomCodeRecipesService service;
    private LoadedCustomCodeRecipeDesc desc;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.recipes.sparkscala.custom");

    public CustomSparkScalaRecipeRunner(JobActivity activity) {
        super(activity);
        this.desc = ((CustomCodeRecipeMeta)RecipeRegistry.getMeta(activity)).getPluginDesc();
    }

    @Override
    public void run() throws Exception {
        final SparkCustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SparkCustomCodeRecipeParams.class);
        this.runSpark("Scala", params.executionEngine, new SparkExecutionEnginesHelper.SparkRecipeJobBuilder(){

            @Override
            public <T extends SparkJob> T buildSparkJob(SparkJobHelper<T> helper, File runDir, SparkSettings sparkSettings, List<SimpleKeyValue> effectiveConf) throws Exception {
                File tmpScriptData = new File(runDir, "script.scala");
                logger.info((Object)("Dumping Scala script to " + String.valueOf(tmpScriptData)));
                String scriptData = CustomSparkScalaRecipeRunner.this.service.getCode(CustomSparkScalaRecipeRunner.this.desc.recipeType);
                DKUFileUtils.writeFileUTF8((File)tmpScriptData, (String)scriptData);
                Boolean useGlobalMetastore = CustomSparkScalaRecipeRunner.this.desc.desc.codeMode == CodeMode.FUNCTION && params.useGlobalMetastore;
                String metastoreDatabase = null;
                if (useGlobalMetastore.booleanValue() && (metastoreDatabase = SparkRecipeUtils.getHiveMetastoreDatabase(CustomSparkScalaRecipeRunner.this.activity, CustomSparkScalaRecipeRunner.this.datasetsDAO)) == null) {
                    logger.warn((Object)"Could not find a metastore database to use from recipe inputs/outputs, will use default. You can override from the code with sqlContext.sql(\"USE my_database\")");
                }
                T job = helper.makeClassJob("Spark-Scala Recipe", true, effectiveConf, "com.dataiku.dip.spark.recipe.CustomSparkScalaRecipeEntryPoint", tmpScriptData.getAbsolutePath(), CustomSparkScalaRecipeRunner.this.desc.desc.codeMode.toString(), useGlobalMetastore.toString(), metastoreDatabase == null ? "" : metastoreDatabase);
                ((SparkJob)job).secretDriverFiles.add(tmpScriptData.getAbsolutePath());
                return job;
            }

            @Override
            public SparkOverrideConfig getRecipeOverrideConf() {
                return params.sparkConfig;
            }
        }, null);
        this.activity.setAllSourcesCompletelyRead();
        this.activity.fillTargetWrittenSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Done");
    }

    @Override
    protected EnvironmentStash prepareEnvStash(File tmpDir, Map<String, String> extraEnv, ContainerExecRuntimeConfig containerConfig, String envName) throws IOException, SQLException, CodedException, DKUSecurityException, InterruptedException {
        EnvironmentStash stash = super.prepareEnvStash(tmpDir, extraEnv, containerConfig, envName);
        SparkCustomCodeRecipeParams params = RecipeRegistry.getParamsAs(this.activity, SparkCustomCodeRecipeParams.class);
        stash.fillForPlugin(this.authCtxService.getAuthCtx(), this.recipe.getProjectKey(), containerConfig, params, this.desc, this.service);
        return stash;
    }

    @Override
    public void init() throws Exception {
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.activity.setStatusMessage("Initializing");
    }
}

