/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.export;

import com.dataiku.dip.containers.exec.ContainerExecRuntimeConfig;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.JobAuthCtxService;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.cde.ContainerizedDSSEngineAble;
import com.dataiku.dip.dataflow.cde.ContainerizedStreamEngineExecutor;
import com.dataiku.dip.dataflow.exec.AbortableRecipeRunner;
import com.dataiku.dip.dataflow.exec.FlowRunnable;
import com.dataiku.dip.dataflow.exec.filter.FilterDesc;
import com.dataiku.dip.dataflow.exec.filter.FilterDescUtils;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowManagedFolder;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.utils.FlowJobUtils;
import com.dataiku.dip.datasets.DatasetSelection;
import com.dataiku.dip.datasets.dynamic.VariablesExpansionLoopItemsIterable;
import com.dataiku.dip.export.BasicExportHandler;
import com.dataiku.dip.export.CustomExportersRegistry;
import com.dataiku.dip.export.ExportParams;
import com.dataiku.dip.export.ExportUtils;
import com.dataiku.dip.export.input.ExportDataset;
import com.dataiku.dip.files.MimeTypeUtils;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.recipes.RecipeRegistry;
import com.dataiku.dip.recipes.RecipeRunner;
import com.dataiku.dip.recipes.consistency.CDECompatibilityCheckerService;
import com.dataiku.dip.recipes.export.ExportRecipeParams;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.shaker.model.DatasetExploreSettings;
import com.dataiku.dip.shaker.model.SerializedShakerScript;
import com.dataiku.dip.shaker.server.DatasetExploreSettingsDAO;
import com.dataiku.dip.util.AutoDelete;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dip.variables.DynamicLevelsStack;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.google.common.io.ByteStreams;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

public class ExportRecipeRunner
implements FlowRunnable,
RecipeRunner,
AbortableRecipeRunner,
ContainerizedDSSEngineAble {
    @Autowired
    private ExportUtils exportUtils;
    @Autowired
    private JobAuthCtxService authCtxService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private CDECompatibilityCheckerService cdeCompatibilityCheckerService;
    private JobActivity activity;
    private RecipeRunnableSubgraph subgraph;
    private FlowRecipe recipe;
    private boolean isRunningInContainer;
    @Autowired
    private DatasetsDAO datasetsDAO;
    protected List<FlowDataset> inputDatasets = new ArrayList<FlowDataset>();
    protected FlowDataset inputFD;
    protected ExportRecipeParams params;
    protected ContainerizedStreamEngineExecutor containerizedRunner;
    private static Logger logger = Logger.getLogger((String)"dku.flow.recipe.export");

    public ExportRecipeRunner(JobActivity activity) {
        this.activity = activity;
        this.subgraph = (RecipeRunnableSubgraph)activity.getSubgraph();
        this.recipe = this.subgraph.getRecipe();
        this.activity.initStatus();
    }

    @Override
    public void setIsRunningInContainer() {
        this.isRunningInContainer = true;
    }

    @Override
    public void init() throws Exception {
        this.activity.setStatusMessage("Initializing");
        this.activity.fillSourceTotalSizes(this.datasetsDAO);
        this.params = RecipeRegistry.getParamsAs(this.activity, ExportRecipeParams.class);
    }

    @Override
    public void run() throws Exception {
        ContainerExecRuntimeConfig containerConfig = this.cdeCompatibilityCheckerService.getContainerConfig(this.isRunningInContainer, this.authCtxService.getAuthCtx(), this.activity.warnContext, this.params.containerSelection, this.recipe.getModel(), null);
        if (containerConfig != null) {
            logger.info((Object)"Run in container");
            this.containerizedRunner = new ContainerizedStreamEngineExecutor(this.recipe, this.activity, containerConfig);
            this.containerizedRunner.init(this.activity, Output.WriteMode.APPEND);
            this.containerizedRunner.run();
        } else {
            this.runLocally();
        }
        this.activity.setAllSourcesCompletelyRead();
        this.activity.setStatusMessage("Done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runLocally() throws Exception {
        String targetPartitionPath;
        FlowManagedFolder fmf = (FlowManagedFolder)this.recipe.getSuccessors().get(0);
        ManagedFolder mf = fmf.getManagedFolder();
        Partition targetPartition = this.activity.getSubgraph().getTargetPartition(fmf);
        try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtxService.getAuthCtx());){
            targetPartitionPath = handler.ensurePartitionFolder(targetPartition);
            if (this.params.clearOutputPartition) {
                handler.delete(targetPartitionPath);
                handler.ensurePartitionFolder(targetPartition);
            }
        }
        for (FlowComputable.FlowComputableWithRole src : this.recipe.getSourcesWithRoles()) {
            if (src.computable.getType() != FlowComputable.FCType.DATASET || !"main".equals(src.role)) continue;
            FlowDataset fd = (FlowDataset)src.computable;
            this.activity.setStatusMessage("Exporting input: " + fd.getFullId());
            ExportParams ep = (ExportParams)JSON.deepCopy((Object)this.params.exportParams);
            ep.contextProjectKey = this.recipe.getProjectKey();
            Dataset dataset = fd.getMandatory(this.datasetsDAO);
            if (dataset.getPartitioningSchema() != null && dataset.getPartitioningSchema().isPartitioned()) {
                ArrayList<String> partitionIds = new ArrayList<String>();
                for (Partition p : this.activity.getSubgraph().getSourcePartitions(fd)) {
                    partitionIds.add(p.id());
                }
                ep.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.SELECTED;
                ep.selection.selectedPartitions = partitionIds;
            } else {
                ep.selection.partitionSelectionMethod = DatasetSelection.PartitionSelectionMethod.ALL;
            }
            SerializedShakerScript.TableColoring tableColoring = this.retrieveTableColoring(ep, dataset.getProjectKey(), dataset.getName());
            VariablesExpansionLoopItemsIterable it = new VariablesExpansionLoopItemsIterable(this.authCtxService.getAuthCtx(), ep.contextProjectKey, this.params.variablesExpansionLoopConfig);
            for (JsonObject jo : it) {
                try {
                    logger.info((Object)("Loop on " + JSON.json((Object)jo)));
                    DynamicLevelsStack.pushLevel(jo);
                    VariablesContext vc = this.variablesService.getForEverything(null, this.authCtxService.getAuthCtx(), ep.contextProjectKey);
                    if (this.params.filter.enabled) {
                        ep.selection.filter = (FilterDesc)JSON.deepCopy((Object)this.params.filter);
                        FilterDescUtils.expandExpressionIfNeeded(ep.selection.filter, vc);
                    }
                    AutoDelete outputFile = null;
                    Object outputFileUnmangledName = null;
                    if (ep.destinationType != ExportParams.ExportDestinationType.CUSTOM_MANAGED) {
                        ep.filenameBase = dataset.getName();
                        MimeTypeUtils.MimeType mimeType = ep.exporterType == null ? this.exportUtils.computeMimeType(ep) : CustomExportersRegistry.getExporter(ep.exporterType).getMimeType(ep);
                        outputFile = FlowJobUtils.getJobTempFile("export-recipe", dataset.getName(), mimeType.extension);
                        outputFileUnmangledName = StringUtils.isNotBlank((String)this.params.outputFilename) ? vc.expand(this.params.outputFilename) : (mimeType.extension == null ? dataset.getName() : (mimeType.extension.startsWith(".") ? dataset.getName() + mimeType.extension : dataset.getName() + "." + mimeType.extension));
                    }
                    logger.info((Object)("Will export to file " + outputFileUnmangledName));
                    ExportDataset ei = new ExportDataset(this.authCtxService.getAuthCtx(), dataset.serialize(), ExportUtils.convertColoring(tableColoring));
                    BasicExportHandler exportHandler = new BasicExportHandler();
                    exportHandler.doExport(this.authCtxService.getAuthCtx(), ei, ep, (File)outputFile);
                    if (ep.destinationType == ExportParams.ExportDestinationType.CUSTOM_MANAGED) continue;
                    if (outputFile == null) {
                        throw new Exception("Failed to initialize temp output file");
                    }
                    try {
                        ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtxService.getAuthCtx());
                        try (FileInputStream in = new FileInputStream((File)outputFile);){
                            OutputStream out = handler.getOutputStream(PathUtils.concatLNT((String[])new String[]{targetPartitionPath, outputFileUnmangledName}));
                            try {
                                ByteStreams.copy((InputStream)in, (OutputStream)out);
                            }
                            finally {
                                if (out == null) continue;
                                out.close();
                            }
                        }
                        finally {
                            if (handler == null) continue;
                            handler.close();
                        }
                    }
                    finally {
                        outputFile.close();
                    }
                }
                finally {
                    DynamicLevelsStack.popLevel();
                }
            }
        }
    }

    private SerializedShakerScript.TableColoring retrieveTableColoring(ExportParams exportParams, String projectKey, String datasetName) {
        try {
            DatasetExploreSettingsDAO exploreSettingsDAO;
            DatasetExploreSettings exploreSettings;
            if (exportParams.applyColoring && (exploreSettings = (exploreSettingsDAO = (DatasetExploreSettingsDAO)SpringUtils.getBean(DatasetExploreSettingsDAO.class)).getUnsafe(projectKey, datasetName)) != null && exploreSettings.script != null) {
                return exploreSettings.script.coloring;
            }
        }
        catch (Exception e) {
            logger.error((Object)String.format("Unable to retrieve table coloring for dataset %s.%s", projectKey, datasetName), (Throwable)e);
        }
        return null;
    }

    @Override
    public void notifyBeforeAborting() {
        if (this.containerizedRunner != null) {
            this.containerizedRunner.notifyBeforeAborting();
        } else {
            Thread.currentThread().interrupt();
        }
    }
}

