/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.streaming.python;

import com.dataiku.dip.dataflow.exec.window.WindowRecipePayloadParams;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class FunctionStreamingFeedParams {
    public List<Consumption> inputs = Lists.newArrayList();
    public List<Production> outputs = Lists.newArrayList();

    public Production getOutputForRef(String ref) {
        return this.outputs.stream().filter(o -> StringUtils.equals((String)ref, (String)o.ref)).findAny().orElse(new Production());
    }

    public Consumption getInputForRef(String ref) {
        return this.inputs.stream().filter(i -> StringUtils.equals((String)ref, (String)i.ref)).findAny().orElse(new Consumption());
    }

    public static class Production {
        public String ref;
        public String checkpointingType;
        public JsonObject checkpointingParams = new JsonObject();

        public CheckpointingParams getTypedParams() {
            if (StringUtils.isBlank((String)this.checkpointingType)) {
                return new NoCheckpointingParams();
            }
            switch (this.checkpointingType) {
                case "none": {
                    return new NoCheckpointingParams();
                }
                case "file": {
                    return (CheckpointingParams)JSON.parse((JsonElement)this.checkpointingParams, FileCheckpointingParams.class);
                }
                case "dataset": {
                    return (CheckpointingParams)JSON.parse((JsonElement)this.checkpointingParams, DatasetCheckpointingParams.class);
                }
                case "kafka_transaction": {
                    return (CheckpointingParams)JSON.parse((JsonElement)this.checkpointingParams, KafkaTransactionCheckpointingParams.class);
                }
            }
            throw new Error("Unreachable");
        }
    }

    public static class Consumption {
        public String ref;
        public boolean windowEnabled;
        public int windowSize;
        public WindowRecipePayloadParams.DateDiffUnit windowUnit;
    }

    public static class KafkaTransactionCheckpointingParams
    implements CheckpointingParams {
        public String checkpointTopic;
        public long checkpointInterval = 100L;
    }

    public static class FileCheckpointingParams
    implements CheckpointingParams {
        public String path;
        public long checkpointInterval = 10000L;
        public long checkpointMaxRows = 100000L;
    }

    public static class DatasetCheckpointingParams
    implements CheckpointingParams {
        public long checkpointInterval = 10000L;
        public long checkpointMaxRows = 100000L;
    }

    public static class NoCheckpointingParams
    implements CheckpointingParams {
    }

    public static interface CheckpointingParams {
    }
}

