/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.remoterun;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.security.rpc.EncryptedRPC;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public class RemoteRunNetworkingUtils {
    private static MainLoggingConfigurator.ProcessType serverKind;
    private static int serverPort;
    private static String hostname;

    public static void setServer(MainLoggingConfigurator.ProcessType processType, int port) {
        serverKind = processType;
        serverPort = port;
    }

    public static MainLoggingConfigurator.ProcessType getServerKind() {
        return serverKind;
    }

    public static String getServerHost() {
        return RemoteRunNetworkingUtils.getBackendHost();
    }

    public static int getServerPort() {
        return serverPort;
    }

    public static String getServerProtocol() {
        return EncryptedRPC.enabled() ? "https" : "http";
    }

    private RemoteRunNetworkingUtils() {
    }

    public static String getBackendHost() {
        if (StringUtils.isEmpty((String)hostname)) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Cannot get backend hostname", e);
            }
        }
        return hostname;
    }

    public static String getBackendPortForLocalAccess() {
        return System.getenv("DKU_BACKEND_PORT");
    }

    public static String getBackendExtPort() {
        return System.getenv("DKU_BACKEND_EXT_PORT");
    }

    public static String getBackendRPCPort() {
        String forcedPort = RemoteRunNetworkingUtils.getBackendExtPort();
        if (StringUtils.isNotBlank((String)forcedPort)) {
            return forcedPort;
        }
        if (EncryptedRPC.enabled()) {
            return System.getenv("DKU_BACKEND_RPC_PORT");
        }
        return System.getenv("DKU_BACKEND_PORT");
    }

    public static String getBasePort() {
        return System.getenv("DKU_BASE_PORT");
    }

    public static String getBackendRPCProtocol() {
        return EncryptedRPC.enabled() ? "https" : "http";
    }

    public static String getBaseProtocol() {
        boolean ssl = "true".equals(DKUApp.getIniValue((String)"server", (String)"ssl", (String)"false"));
        return ssl ? "https" : "http";
    }

    public static String getBaseSslCertificateAsB64() throws IOException {
        String certFilePath = DKUApp.getIniValue((String)"server", (String)"ssl_certificate", (String)"");
        File f = new File(certFilePath);
        if (f.exists()) {
            String cert = DKUFileUtils.readFileToStringUTF8((File)f);
            return "b64:" + Base64.encodeBase64String((byte[])cert.getBytes(StandardCharsets.UTF_8));
        }
        return "";
    }

    public static String getStudioExternalURL() {
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        String studioUrl = generalSettings.studioExternalUrl;
        if (StringUtils.isBlank((String)studioUrl)) {
            studioUrl = String.format("http://%s:%s", RemoteRunNetworkingUtils.getBackendHost(), System.getenv("DKU_NGINX_PORT"));
        }
        return studioUrl;
    }

    public static String guessDkuBackendExternalUrl(boolean forK8s) {
        String externalUrl = "";
        if (forK8s) {
            String externalHost = hostname;
            String forcedPort = RemoteRunNetworkingUtils.getBackendExtPort();
            String port = StringUtils.isNotBlank((String)forcedPort) ? forcedPort : RemoteRunNetworkingUtils.getBasePort();
            String protocol = RemoteRunNetworkingUtils.getBackendRPCProtocol();
            if (StringUtils.isNotEmpty((String)protocol) && StringUtils.isNotEmpty((String)externalHost) && StringUtils.isNotEmpty((String)port)) {
                externalUrl = String.format("%s://%s:%s", protocol, externalHost, port);
            }
        }
        if (StringUtils.isBlank((String)externalUrl)) {
            GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
            externalUrl = generalSettings.studioExternalUrl;
        }
        if (StringUtils.isBlank((String)externalUrl)) {
            return "";
        }
        return externalUrl;
    }

    public static String guessLocalEventServerExtUrl(boolean forK8s) {
        NodesDirectoryService nodesDirectoryService = (NodesDirectoryService)SpringUtils.getBean(NodesDirectoryService.class);
        NodesDirectory nd = nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        String externalUrl = nd.enabled && nd.hasEventServerNode() && Objects.equals(nd.getCurrentNode().nodeId, nd.eventServerNodeId) ? nd.getCurrentNode().externalUrl : RemoteRunNetworkingUtils.guessDkuBackendExternalUrl(forK8s);
        return externalUrl;
    }

    static {
        hostname = System.getenv("DKU_BACKEND_EXT_HOST");
    }
}

