/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.requestcenter;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class Request {
    public String requestId;
    public String requesterLogin;
    public String requestMessage;
    public RequestType requestType;
    public RequestObjectType objectType;
    @Nullable
    public String objectProjectKey;
    public String objectWorkspaceKey;
    @Nullable
    public String objectId;
    public RequestDetails requestDetails;
    public long createdOn;
    public RequestStatus status;
    public String closingMessage;
    public long closedOn;
    @Nullable
    public String closingUser;
    public String objectDisplayName;
    public String savedModelMLCategory;

    public boolean hasValidObjectId() {
        if (this.requestType.isInstanceAccessRequest() || this.requestType.isProfileUpgradeRequest()) {
            return true;
        }
        return StringUtils.isNotBlank((String)this.objectId);
    }

    public static enum RequestType {
        PROJECT_READ,
        PROJECT_WRITE,
        PROJECT_EXECUTE_APP,
        OBJECT_SHARE,
        INSTALL_PLUGIN,
        UPDATE_PLUGIN,
        INSTALL_CODE_ENV,
        INSTANCE_ACCESS,
        PROFILE_UPGRADE;


        public List<Privileges.ProjectLevelPrivilegeType> getProjectLevelRequiredRights() {
            switch (this) {
                case PROJECT_READ: {
                    return Arrays.asList(Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS, Privileges.ProjectLevelPrivilegeType.READ_CONF);
                }
                case PROJECT_WRITE: {
                    return Arrays.asList(Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS, Privileges.ProjectLevelPrivilegeType.WRITE_CONF);
                }
                case PROJECT_EXECUTE_APP: {
                    return Arrays.asList(Privileges.ProjectLevelPrivilegeType.EDIT_PERMISSIONS, Privileges.ProjectLevelPrivilegeType.EXECUTE_APP);
                }
                case OBJECT_SHARE: {
                    return Collections.singletonList(Privileges.ProjectLevelPrivilegeType.MANAGE_EXPOSED_ELEMENTS);
                }
            }
            throw new NotImplementedException("Unsupported type: " + String.valueOf((Object)this));
        }

        public Privileges.PluginLevelPrivilegeType getPluginRequiredRight() {
            return Privileges.PluginLevelPrivilegeType.ADMIN;
        }

        public boolean isAccessRequest() {
            return this == PROJECT_READ || this == PROJECT_WRITE || this == PROJECT_EXECUTE_APP;
        }

        public boolean isSharingRequest() {
            return this == OBJECT_SHARE;
        }

        public boolean isPluginRequest() {
            return this == INSTALL_PLUGIN || this == UPDATE_PLUGIN;
        }

        public boolean isCodeEnvRequest() {
            return this == INSTALL_CODE_ENV;
        }

        public boolean isInstanceAccessRequest() {
            return this == INSTANCE_ACCESS;
        }

        public boolean isProfileUpgradeRequest() {
            return this == PROFILE_UPGRADE;
        }

        public String toHumanReadableString() {
            switch (this) {
                case PROJECT_READ: 
                case PROJECT_WRITE: 
                case PROJECT_EXECUTE_APP: {
                    return "access";
                }
                case OBJECT_SHARE: {
                    return "sharing";
                }
                case INSTALL_PLUGIN: 
                case UPDATE_PLUGIN: {
                    return "plugin";
                }
                case INSTALL_CODE_ENV: {
                    return "code env";
                }
                case INSTANCE_ACCESS: {
                    return "instance access";
                }
                case PROFILE_UPGRADE: {
                    return "profile upgrade";
                }
            }
            throw new NotImplementedException("Unsupported type: " + String.valueOf((Object)this));
        }
    }

    public static class CodeEnvRequestDetails
    extends RequestDetails {
        public static final String TYPE = "CodeEnvRequestDetails";
        public CodeEnvModel.AbstractEnvDesc desc;
        public CodeEnvModel.EnvLang envLang;
        public String specPackagesList;
        public String specCondaEnvironment;
        public CodeEnvRequestSource source;
        public String targetName;

        public boolean isManual() {
            return this.source == CodeEnvRequestSource.MANUAL;
        }

        public static enum CodeEnvRequestSource {
            MANUAL,
            SOLUTION;

        }
    }

    public static class PluginRequestDetails
    extends RequestDetails {
        public static final String TYPE = "PluginRequestDetails";
    }

    public static class ObjectSharingRequestDetails
    extends RequestDetails {
        public static final String TYPE = "ObjectShareDetails";
        public String sharingTargetProject;
    }

    public static class EmptyRequestDetails
    extends RequestDetails {
        public static final String TYPE = "EmptyDetails";
    }

    @PolyJSON(value={@Mapping(value=EmptyRequestDetails.class, type="EmptyDetails"), @Mapping(value=ObjectSharingRequestDetails.class, type="ObjectShareDetails"), @Mapping(value=PluginRequestDetails.class, type="PluginRequestDetails"), @Mapping(value=CodeEnvRequestDetails.class, type="CodeEnvRequestDetails")})
    public static abstract class RequestDetails {
    }

    public static enum RequestObjectType {
        PROJECT,
        APP,
        DATASET,
        MANAGED_FOLDER,
        SAVED_MODEL,
        RETRIEVABLE_KNOWLEDGE,
        MODEL_EVALUATION_STORE,
        PLUGIN,
        CODE_ENV,
        INSTANCE,
        PROFILE;


        public RequestType getDefaultRequestType() {
            switch (this) {
                case PROJECT: {
                    return RequestType.PROJECT_READ;
                }
                case APP: {
                    return RequestType.PROJECT_EXECUTE_APP;
                }
                case DATASET: 
                case MANAGED_FOLDER: 
                case SAVED_MODEL: 
                case RETRIEVABLE_KNOWLEDGE: 
                case MODEL_EVALUATION_STORE: {
                    return RequestType.OBJECT_SHARE;
                }
                case PLUGIN: {
                    return RequestType.INSTALL_PLUGIN;
                }
                case CODE_ENV: {
                    return RequestType.INSTALL_CODE_ENV;
                }
                case INSTANCE: {
                    return RequestType.INSTANCE_ACCESS;
                }
                case PROFILE: {
                    return RequestType.PROFILE_UPGRADE;
                }
            }
            throw new NotImplementedException("Unsupported object type: " + String.valueOf((Object)this));
        }

        public Optional<ITaggingService.TaggableType> toTaggableType() {
            if (this == APP) {
                return Optional.of(ITaggingService.TaggableType.PROJECT);
            }
            return Arrays.stream(ITaggingService.TaggableType.values()).filter(t -> t.name().equals(this.toString())).findFirst();
        }

        public static RequestObjectType fromTaggableType(ITaggingService.TaggableType type) {
            return RequestObjectType.valueOf(type.toString());
        }

        public boolean needsNameEnrichment() {
            return this.equals((Object)MANAGED_FOLDER) || this.equals((Object)RETRIEVABLE_KNOWLEDGE) || this.equals((Object)SAVED_MODEL) || this.equals((Object)MODEL_EVALUATION_STORE) || this.equals((Object)PLUGIN) || this.equals((Object)CODE_ENV);
        }

        public static boolean supportsShareRequest(ITaggingService.TaggableType type) {
            switch (type) {
                case DATASET: 
                case MANAGED_FOLDER: 
                case SAVED_MODEL: 
                case RETRIEVABLE_KNOWLEDGE: 
                case MODEL_EVALUATION_STORE: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum RequestStatus {
        PENDING,
        APPROVED,
        REJECTED;

    }
}

