/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sanitycheck.detectors;

import com.dataiku.dip.sanitycheck.detectors.ExecutionException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component
class PythonEnvironmentInformation {
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.sanitycheck.pythonenvironmentinformation");

    PythonEnvironmentInformation() {
    }

    String getListOfManuallyInstalledPackages() throws ExecutionException {
        ProcessBuilder pb = new ProcessBuilder(System.getenv("DKUPYTHONBIN"), "-m", "pip", "freeze", "-l");
        try {
            logger.debugV("Run command: %s", new Object[]{String.join((CharSequence)" ", pb.command())});
            String output = new String(DKUtils.execAndGetOutput((ProcessBuilder)pb));
            logger.debugV("Command stdout: %s", new Object[]{output});
            return output;
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException(e);
        }
    }

    String getPythonVersion() throws ExecutionException {
        return this.getPythonVersion(System.getenv("DKUPYTHONBIN"));
    }

    String getPythonVersion(String pythonBin) throws ExecutionException {
        ProcessBuilder pb = new ProcessBuilder(pythonBin, "-c", "import sys;print(sys.version)");
        try {
            logger.debugV("Run command: %s", new Object[]{String.join((CharSequence)" ", pb.command())});
            String version = new String(DKUtils.execAndGetOutput((ProcessBuilder)pb));
            logger.debugV("Command stdout: %s", new Object[]{version});
            return version;
        }
        catch (IOException | InterruptedException e) {
            throw new ExecutionException(e);
        }
    }
}

