/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.reports;

import com.dataiku.dip.scheduler.reports.DistillationUnit;
import com.dataiku.dip.scheduler.reports.ReportItem;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.server.notifications.VariableLookup;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;

public class ItemFieldDistillation
implements DistillationUnit {
    private final Class<? extends ReportItem> reportItemClazz;
    private final Class<? extends ReportTargetItem> reportTargetItemClazz;
    private final String field;
    private List<String> values = Lists.newArrayList();
    private Field itemField;
    private Field targetField;
    private String variableName;
    private static DKULogger logger = DKULogger.getLogger((String)"dip.reporter.itemfield");

    public ItemFieldDistillation(Class<? extends ReportItem> reportItemClazz, Class<? extends ReportTargetItem> reportTargetItemClazz, String field, String variableName) {
        this.variableName = variableName;
        this.reportItemClazz = reportItemClazz;
        this.reportTargetItemClazz = reportTargetItemClazz;
        this.field = field;
        if (reportItemClazz != null) {
            try {
                this.itemField = reportItemClazz.getDeclaredField(field);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
        if (reportTargetItemClazz != null) {
            try {
                this.targetField = reportTargetItemClazz.getDeclaredField(field);
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void getResult(VariableLookup lookup) {
        if (this.values.size() == 0) {
            return;
        }
        lookup.addVariable(this.variableName, Joiner.on((String)", ").join(this.values));
    }

    @Override
    public void handle(ReportItem item) {
        boolean targetClazzOk;
        boolean itemClazzOk = this.reportItemClazz == null || this.reportItemClazz.isInstance(item);
        boolean bl = targetClazzOk = this.reportTargetItemClazz == null || this.reportTargetItemClazz.isInstance(item.getTargetItem());
        if (itemClazzOk && targetClazzOk) {
            Object value;
            if (this.itemField != null) {
                try {
                    this.values.add(this.itemField.get(item).toString());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error((Object)"Failed to read field from item", (Throwable)e);
                }
            } else if (this.targetField != null && item.getTargetItem() != null) {
                try {
                    this.values.add(this.targetField.get(item.getTargetItem()).toString());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    logger.error((Object)"Failed to read field from target", (Throwable)e);
                }
            } else if (item.info.containsKey(this.field) && (value = item.info.get(this.field)) != null) {
                this.values.add(value.toString());
            }
        }
    }
}

